/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service;

import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class PermissionServiceImpl
implements PermissionService {
    @Autowired
    private PermissionManager permissionManager;
    @Autowired
    private ProjectManager projectManager;

    @Override
    public boolean hasPermission(ApplicationUser user, Issue issue, int permission) {
        Validate.notNull((Object)issue);
        return this.permissionManager.hasPermission(permission, issue, user);
    }

    @Override
    public boolean hasPermission(ApplicationUser user, Project project, int permission) {
        Validate.notNull((Object)project);
        return this.permissionManager.hasPermission(permission, project, user);
    }

    @Override
    public boolean hasSomePermission(ApplicationUser user, Collection<Project> projects, int permission) {
        for (Project project : projects) {
            if (!this.permissionManager.hasPermission(permission, project, user)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAllPermission(ApplicationUser user, Collection<Project> projects, int permission) {
        if (projects.isEmpty()) {
            return false;
        }
        for (Project project : projects) {
            if (this.permissionManager.hasPermission(permission, project, user)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasGlobalPermission(ApplicationUser user, int permission) {
        return this.permissionManager.hasPermission(permission, user);
    }

    @Override
    public boolean hasGlobalPermission(@Nullable ApplicationUser user, @Nonnull GlobalPermissionKey globalPermissionKey) {
        Preconditions.checkNotNull((Object)globalPermissionKey);
        return ComponentAccessor.getGlobalPermissionManager().hasPermission(globalPermissionKey, user);
    }

    @Override
    public boolean isProjectAdministrator(ApplicationUser user, Collection<Project> projects) {
        return this.hasAllPermission(user, projects, 23);
    }

    @Override
    public boolean isAllProjectsAdministrator(ApplicationUser user) {
        return this.isProjectAdministrator(user, this.projectManager.getProjectObjects());
    }

    @Override
    public boolean isJiraAdministrator(ApplicationUser user) {
        return this.permissionManager.hasPermission(0, user);
    }

    @Override
    public boolean isJiraSystemAdministrator(ApplicationUser user) {
        return this.permissionManager.hasPermission(44, user);
    }

    @Override
    public boolean canUpdateIssue(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(12, issue, user);
    }

    @Override
    public boolean canUpdateLinks(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(21, issue, user);
    }

    @Override
    public boolean canCreateIssue(ApplicationUser user) {
        return this.permissionManager.hasProjects(11, user);
    }

    @Override
    public boolean canCreateProject(ApplicationUser user) {
        return this.permissionManager.hasPermission(0, user);
    }

    @Override
    public Collection<Project> createIssueProjects(ApplicationUser user) {
        return this.permissionManager.getProjects(11, user);
    }
}

