/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service;

import com.atlassian.annotations.PublicApi;
import com.atlassian.greenhopper.service.PageRequest;
import javax.annotation.Nullable;

@PublicApi
public final class PageRequests {
    private static PageRequest ALL_REQUEST = new PageRequestImpl(0L, 0x100000);

    public static PageRequest request(@Nullable Long start, @Nullable Integer limit) {
        return new PageRequestImpl(start, limit);
    }

    public static PageRequest all() {
        return ALL_REQUEST;
    }

    private static class PageRequestImpl
    implements PageRequest {
        private final Long start;
        private final Integer limit;

        public PageRequestImpl(@Nullable Long start, @Nullable Integer limit) {
            this.start = start == null || start < 0L ? 0L : start;
            this.limit = limit == null ? PageRequest.MAX_PAGE_LIMIT : (limit <= 0 ? 1 : Math.min(limit, 0x100000));
        }

        @Override
        public Integer getLimit() {
            return this.limit;
        }

        @Override
        public Long getStart() {
            return this.start;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageRequestImpl that = (PageRequestImpl)o;
            if (this.start != that.start) {
                return false;
            }
            return this.limit == that.limit;
        }

        public int hashCode() {
            int result = (int)(this.start ^ this.start >>> 32);
            result = 31 * result + this.limit;
            return result;
        }

        public String toString() {
            return "PageRequestImpl{start=" + this.start + ", limit=" + this.limit + '}';
        }
    }
}

