/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service;

import com.atlassian.greenhopper.service.IssueIndexService;
import com.atlassian.greenhopper.upgrade.IssueIdsIssueIterable;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.task.context.Contexts;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="gh-issueIndexingService")
public class IssueIndexServiceImpl
implements IssueIndexService {
    private Logger log = Logger.getLogger(IssueIndexServiceImpl.class);
    @Autowired
    private IssueIndexingService issueIndexingService;
    @Autowired
    private IssueManager issueManager;

    @Override
    public void reIndexAll() {
        try {
            this.issueIndexingService.reIndexAll();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to reindex all issues", (Throwable)e);
        }
    }

    @Override
    public void reIndex(Issue issue) {
        IssueIndexingParams params = IssueIndexingParams.builder().setComments(true).setChangeHistory(true).build();
        this.reIndex(issue, params);
    }

    @Override
    public void reIndex(Issue issue, IssueIndexingParams issueIndexingParams) {
        Validate.notNull((Object)issue);
        try {
            this.issueIndexingService.reIndex(issue, issueIndexingParams);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to reindex issue", (Throwable)e);
        }
    }

    @Override
    public void reIndexWithIds(Long ... ids) {
        List<Long> idsList = Arrays.asList(ids);
        this.reIndexIssuesWithIds(idsList);
    }

    @Override
    public ServiceOutcome<Void> reIndexIssues(Collection<Issue> issues) {
        IssueIndexingParams params = IssueIndexingParams.builder().setComments(true).setChangeHistory(true).build();
        return this.reIndexIssues(issues, params);
    }

    @Override
    public ServiceOutcome<Void> reIndexIssues(Collection<Issue> issues, IssueIndexingParams issueIndexingParams) {
        Validate.notNull(issues);
        if (issues.isEmpty()) {
            return ServiceOutcomeImpl.ok(null);
        }
        try {
            long reIndexTime = this.issueIndexingService.reIndexIssueObjects(issues, issueIndexingParams);
            if (reIndexTime < 0L) {
                return ServiceOutcomeImpl.error((String)"Failed to index issues, foreground indexing may be taking place");
            }
            return ServiceOutcomeImpl.ok(null);
        }
        catch (IndexException e) {
            this.log.warn((Object)"Failed to reindex issues", (Throwable)e);
            return ServiceOutcomeImpl.error((String)"Caught exception while re-indexing issues, see log for more details");
        }
    }

    @Override
    public void reIndexIssuesWithIds(Collection<Long> issueIds) {
        Validate.notNull(issueIds);
        if (issueIds.isEmpty()) {
            return;
        }
        try {
            this.issueIndexingService.reIndexIssues((IssuesIterable)new IssueIdsIssueIterable(issueIds, this.issueManager), Contexts.nullContext());
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to reindex issues", (Throwable)e);
        }
    }

    @Override
    public void reindexIssuesAndSubtasks(Collection<Long> issueIds) {
        Validate.notNull(issueIds);
        for (Long issueId : issueIds) {
            this.reindexIssueAndSubtasks(issueId);
        }
    }

    @Override
    public void reindexIssueAndSubtasks(Long issueId) {
        Validate.notNull((Object)issueId);
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue != null) {
            this.reindexIssueAndSubtasks((Issue)issue);
        }
    }

    @Override
    public void reindexIssueAndSubtasks(Issue issue) {
        IssueIndexingParams params = IssueIndexingParams.builder().setComments(true).setChangeHistory(true).build();
        this.reindexIssueAndSubtasks(issue, params);
    }

    @Override
    public void reindexIssueAndSubtasks(@Nonnull Issue issue, IssueIndexingParams issueIndexingParams) {
        Validate.notNull((Object)issue);
        this.reindexIssueAndSubtasks((Collection<Issue>)ImmutableList.of((Object)issue), issueIndexingParams);
    }

    @Override
    public ServiceOutcome<Void> reindexIssueAndSubtasks(@Nonnull Collection<Issue> issues, IssueIndexingParams issueIndexingParams) {
        Validate.notNull(issues);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Issue issue : issues) {
            builder.add((Object)issue);
            builder.addAll((Iterable)issue.getSubTaskObjects());
        }
        return this.reIndexIssues((Collection<Issue>)builder.build(), issueIndexingParams);
    }
}

