/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class I18nFactoryServiceImpl
implements I18nFactoryService {
    static final Logger log = Logger.getLogger(I18nFactoryServiceImpl.class);
    @Autowired
    ApplicationProperties applicationProperties;
    @Autowired
    I18nHelper.BeanFactory beanFactory;

    @Override
    public I18n2 getI18n(ApplicationUser user) {
        Locale userLocale = I18nBean.getLocaleFromUser((ApplicationUser)user);
        return this.getI18n(userLocale);
    }

    @Override
    public I18n2 getI18n() {
        Locale defaultLocale = this.applicationProperties.getDefaultLocale();
        return this.getI18n(defaultLocale);
    }

    @Override
    public I18n2 getI18n(Locale locale) {
        I18nHelper helper = this.beanFactory.getInstance(locale);
        return new I18nHelperWrapper(helper);
    }

    static class I18nHelperWrapper
    implements I18n2 {
        private final I18nHelper helper;
        private static final String EMPTY_STRING = "";

        I18nHelperWrapper(I18nHelper helper) {
            this.helper = helper;
        }

        @Override
        public Locale getLocale() {
            return this.helper.getLocale();
        }

        @Override
        public String getText(String key) {
            if (this.nullCheck(key)) {
                return EMPTY_STRING;
            }
            try {
                return this.helper.getText(key);
            }
            catch (StringIndexOutOfBoundsException e) {
                return key;
            }
        }

        @Override
        public String getText(String key, Object parameter) {
            if (this.nullCheck(key)) {
                return EMPTY_STRING;
            }
            try {
                return this.helper.getText(key, parameter);
            }
            catch (Exception e) {
                return key;
            }
        }

        @Override
        public String getText(String key, Object ... params) {
            if (this.nullCheck(key)) {
                return EMPTY_STRING;
            }
            try {
                return this.helper.getText(key, (Object)params);
            }
            catch (Exception e) {
                return key;
            }
        }

        @Override
        public String getText(String key, Object parameter1, Object parameter2) {
            return this.getText(key, new Object[]{parameter1, parameter2});
        }

        @Override
        public String getText(String key, Object parameter1, Object parameter2, Object parameter3) {
            return this.getText(key, new Object[]{parameter1, parameter2, parameter3});
        }

        @Override
        public String getText(String key, Object parameter1, Object parameter2, Object parameter3, Object parameter4) {
            return this.getText(key, new Object[]{parameter1, parameter2, parameter3, parameter4});
        }

        @Override
        public String getText(String key, Object parameter1, Object parameter2, Object parameter3, Object parameter4, Object parameter5) {
            return this.getText(key, new Object[]{parameter1, parameter2, parameter3, parameter5});
        }

        private boolean nullCheck(String key) {
            if (key == null) {
                log.warn((Object)"null key passed to i18n.getText", (Throwable)new IllegalArgumentException("The key argument must not be null"));
                return true;
            }
            return false;
        }
    }
}

