/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service;

import com.atlassian.event.api.EventListener;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.GreenHopperCache;
import com.atlassian.jira.event.ClearCacheEvent;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="gh-greenHopperCacheManager")
public class GreenHopperCacheManager {
    public static final String SERVICE = "gh-greenHopperCacheManager";
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;
    private final AtomicBoolean clearCacheRequested = new AtomicBoolean(false);
    private volatile boolean pluginAlive;

    public void notifyPluginAlive() {
        this.pluginAlive = true;
        if (this.clearCacheRequested.compareAndSet(true, false)) {
            this.clearCaches(null);
        }
    }

    @EventListener
    public void clearCaches(@Nullable ClearCacheEvent event) {
        if (!this.pluginAlive) {
            this.logger.info("ClearCacheEvent triggered but plugin was not yet alive...", new Object[0]);
            this.clearCacheRequested.set(true);
            return;
        }
        this.logger.info("Clearing out all GreenHopper caches...", new Object[0]);
        this.logger.info("Clearing cache for bean 'greenHopper'", new Object[0]);
        Map greenHopperCaches = this.applicationContext.getBeansOfType(GreenHopperCache.class);
        for (Map.Entry entry : greenHopperCaches.entrySet()) {
            this.logger.info("Clearing cache for bean '%s'", entry.getKey());
            ((GreenHopperCache)entry.getValue()).flushCache();
        }
    }
}

