/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sampledata;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.sampledata.SampleDataGeneratorComponent;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.version.VersionService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonNode;

class VersionGeneratorComponent
implements SampleDataGeneratorComponent {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private final VersionService versionService;
    private final Map<String, String> versionDataMap = new HashMap<String, String>();

    public VersionGeneratorComponent(VersionService versionService) {
        this.versionService = versionService;
    }

    @Override
    public void parseData(JsonNode ghSampleNode) {
        JsonNode versionsNode = ghSampleNode.get("versions");
        if (versionsNode == null) {
            return;
        }
        Iterator fieldNames = versionsNode.getFieldNames();
        while (fieldNames.hasNext()) {
            String versionKey = (String)fieldNames.next();
            this.versionDataMap.put(versionKey, versionsNode.get(versionKey).getTextValue());
        }
    }

    @Override
    public boolean isProjectRequired() {
        return !this.versionDataMap.isEmpty();
    }

    @Override
    public Map<String, Object> runBeforeImport(ApplicationUser currentUser, @Nullable Project project) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String versionKey : this.versionDataMap.keySet()) {
            String versionName = this.versionDataMap.get(versionKey);
            this.log.info("Creating version with name '" + versionName + "'", new Object[0]);
            ServiceOutcome<Pair<Project, Version>> outcome = this.versionService.createVersion(currentUser, project, versionName, null, null, null);
            if (outcome.isInvalid()) {
                this.log.warn("Could not create version with name '" + versionName + "'\nGot errors: " + outcome.getErrors(), new Object[0]);
                continue;
            }
            Version version = (Version)outcome.getValue().second();
            params.put(versionKey + "_id", version.getId());
            params.put(versionKey + "_name", version.getName());
        }
        return params;
    }

    @Override
    public void runAfterImport(ApplicationUser currentUser, Project project) {
    }
}

