/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sampledata;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.sampledata.SampleDataGeneratorComponent;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonNode;

class StatusGeneratorComponent
implements SampleDataGeneratorComponent {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private final WorkflowService workflowService;
    private final Map<String, Object> statusMapping = new HashMap<String, Object>();

    public StatusGeneratorComponent(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Override
    public void parseData(JsonNode ghSampleNode) {
        JsonNode statusesNode = ghSampleNode.get("statuses");
        if (statusesNode == null) {
            return;
        }
        Iterator fieldNames = statusesNode.getFieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            Status status = this.workflowService.getStatusByName(statusesNode.get(fieldName).getTextValue());
            if (status == null) {
                this.log.warn("Status with name " + fieldName + " could not be found, but was expected by sample data", new Object[0]);
                continue;
            }
            this.statusMapping.put(fieldName, status.getId());
        }
    }

    @Override
    public boolean isProjectRequired() {
        return false;
    }

    @Override
    public Map<String, Object> runBeforeImport(ApplicationUser currentUser, @Nullable Project project) {
        return this.statusMapping;
    }

    @Override
    public void runAfterImport(ApplicationUser currentUser, Project project) {
    }
}

