/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sampledata;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.sampledata.SampleDataGeneratorComponent;
import com.atlassian.greenhopper.sampledata.SprintDateTimes;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonNode;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

class SprintGeneratorComponent
implements SampleDataGeneratorComponent {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private final SprintManager sprintManager;
    private final Map<String, SprintData> sprintDataMap = new HashMap<String, SprintData>();

    public SprintGeneratorComponent(SprintManager sprintManager) {
        this.sprintManager = sprintManager;
    }

    @Override
    public void parseData(JsonNode ghSampleNode) {
        JsonNode sprints = ghSampleNode.get("sprints");
        if (sprints == null) {
            return;
        }
        DateTime currentTime = DateTime.now();
        Iterator fieldNames = sprints.getFieldNames();
        while (fieldNames.hasNext()) {
            String sprintKey = (String)fieldNames.next();
            this.sprintDataMap.put(sprintKey, this.parseSprint(currentTime, sprints.get(sprintKey)));
        }
    }

    @Override
    public boolean isProjectRequired() {
        return false;
    }

    @Override
    public Map<String, Object> runBeforeImport(ApplicationUser currentUser, @Nullable Project project) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String sprintKey : this.sprintDataMap.keySet()) {
            SprintData sprintData = this.sprintDataMap.get(sprintKey);
            ServiceOutcome<Sprint> newSprint = this.sprintManager.createSprint(sprintData.getSprint());
            if (newSprint.isValid()) {
                params.put(sprintKey, newSprint.getValue().getId());
                this.sprintDataMap.put(sprintKey, new SprintData(newSprint.getValue(), sprintData.getDatePeriods()));
                continue;
            }
            this.log.warn("Could not create sample data sprint: " + sprintData + "\nGot errors: " + newSprint.getErrors(), new Object[0]);
        }
        return params;
    }

    @Override
    public void runAfterImport(ApplicationUser currentUser, Project project) {
        this.updateSprintDates();
    }

    private SprintData parseSprint(DateTime currentTime, JsonNode sprintJson) {
        JsonNode nameNode;
        JsonNode stateNode;
        JsonNode completedNode;
        JsonNode endsNode;
        Sprint.SprintBuilder builder = Sprint.builder();
        HashMap<SprintDateTimes, Period> periods = new HashMap<SprintDateTimes, Period>();
        JsonNode startedNode = sprintJson.get("started");
        if (startedNode != null) {
            Period started = Period.parse((String)startedNode.getTextValue());
            builder.startDate(currentTime.plus((ReadablePeriod)started));
            periods.put(SprintDateTimes.STARTED, started);
        }
        if ((endsNode = sprintJson.get("ends")) != null) {
            Period ends = Period.parse((String)endsNode.getTextValue());
            builder.endDate(currentTime.plus((ReadablePeriod)ends));
            periods.put(SprintDateTimes.ENDS, ends);
        }
        if ((completedNode = sprintJson.get("completed")) != null) {
            Period completed = Period.parse((String)completedNode.getTextValue());
            builder.completeDate(currentTime.plus((ReadablePeriod)completed));
            periods.put(SprintDateTimes.COMPLETED, completed);
            builder.state(Sprint.State.CLOSED);
        }
        if ((stateNode = sprintJson.get("state")) != null && stateNode.getTextValue().equals("ACTIVE")) {
            builder.state(Sprint.State.ACTIVE);
        }
        if ((nameNode = sprintJson.get("name")) != null) {
            String name = nameNode.getTextValue();
            builder.name(name);
        }
        return new SprintData(builder.build(), periods);
    }

    private void updateSprintDates() {
        DateTime now = DateTime.now();
        for (SprintData sprintData : this.sprintDataMap.values()) {
            Sprint.SprintBuilder builder = Sprint.builder(sprintData.getSprint());
            Map<SprintDateTimes, Period> datePeriods = sprintData.getDatePeriods();
            if (datePeriods.containsKey((Object)SprintDateTimes.COMPLETED)) {
                builder.completeDate(now.plus((ReadablePeriod)datePeriods.get((Object)SprintDateTimes.COMPLETED)));
            }
            if (datePeriods.containsKey((Object)SprintDateTimes.STARTED)) {
                builder.startDate(now.plus((ReadablePeriod)datePeriods.get((Object)SprintDateTimes.STARTED)));
            }
            if (datePeriods.containsKey((Object)SprintDateTimes.ENDS)) {
                builder.endDate(now.plus((ReadablePeriod)datePeriods.get((Object)SprintDateTimes.ENDS)));
            }
            this.sprintManager.updateSprint(builder.build());
        }
    }

    private static class SprintData {
        private final Sprint sprint;
        private final Map<SprintDateTimes, Period> datePeriods;

        SprintData(Sprint sprint, Map<SprintDateTimes, Period> datePeriods) {
            this.sprint = sprint;
            this.datePeriods = datePeriods;
        }

        public Sprint getSprint() {
            return this.sprint;
        }

        public Map<SprintDateTimes, Period> getDatePeriods() {
            return this.datePeriods;
        }
    }
}

