/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sampledata;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.issue.util.OrderedPriorityHelper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.project.ProjectType;
import com.atlassian.greenhopper.sampledata.EpicGeneratorComponent;
import com.atlassian.greenhopper.sampledata.FieldGeneratorComponent;
import com.atlassian.greenhopper.sampledata.IssueTypeGeneratorComponent;
import com.atlassian.greenhopper.sampledata.PriorityGeneratorComponent;
import com.atlassian.greenhopper.sampledata.SampleDataGenerator;
import com.atlassian.greenhopper.sampledata.SampleDataGeneratorComponentList;
import com.atlassian.greenhopper.sampledata.SprintGeneratorComponent;
import com.atlassian.greenhopper.sampledata.StatusGeneratorComponent;
import com.atlassian.greenhopper.sampledata.VersionGeneratorComponent;
import com.atlassian.greenhopper.service.IssueIndexService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.lexorank.LexoRankChange;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.project.ProjectService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPresetService;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.version.VersionService;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowPresets;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowService;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.greenhopper.web.rapid.project.AgileProjectConfigurator;
import com.atlassian.greenhopper.web.rapid.view.RapidViewHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.sample.Callbacks;
import com.atlassian.jira.plugins.importer.sample.SampleDataImporter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.PluginAccessor;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.ofbiz.core.entity.GenericEntityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SampleDataGeneratorImpl
implements SampleDataGenerator {
    private static final String RESOURCE_PATH_PREFIX = "sampledata/";
    private final AgileProjectConfigurator agileProjectConfigurator;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final SampleDataImporter importer;
    private final PluginAccessor pluginAccessor;
    private final ObjectMapper mapper;
    private final SprintManager sprintManager;
    private final WorkflowService workflowService;
    private final CustomFieldManager customFieldManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SimplifiedWorkflowService simplifiedWorkflowService;
    private final LexoRankCustomFieldService rankCustomFieldService;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final RapidViewHelper rapidViewHelper;
    private final RapidViewPresetService rapidViewPresetService;
    private final ColumnService columnService;
    private final IssueFactory issueFactory;
    private final IssueTypeService issueTypeService;
    private final ProjectService projectService;
    private final EpicCustomFieldService epicCustomFieldService;
    private final LexoRankManager lexoRankManager;
    private final VersionService versionService;
    private final OrderedPriorityHelper orderedPriorityHelper;
    private final IssueIndexService issueIndexService;
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());

    @Autowired
    public SampleDataGeneratorImpl(SampleDataImporter importer, AgileProjectConfigurator agileProjectConfigurator, ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nBeanFactory, PluginAccessor pluginAccessor, SprintManager sprintManager, WorkflowService workflowService, CustomFieldManager customFieldManager, JiraAuthenticationContext jiraAuthenticationContext, SimplifiedWorkflowService simplifiedWorkflowService, LexoRankCustomFieldService rankCustomFieldService, ProjectManager projectManager, IssueManager issueManager, LexoRankManager lexoRankManager, RapidViewHelper rapidViewHelper, RapidViewPresetService rapidViewPresetService, ColumnService columnService, IssueFactory issueFactory, IssueTypeService issueTypeService, ProjectService projectService, EpicCustomFieldService epicCustomFieldService, VersionService versionService, OrderedPriorityHelper orderedPriorityHelper, IssueIndexService issueIndexService) {
        this.importer = importer;
        this.agileProjectConfigurator = agileProjectConfigurator;
        this.applicationProperties = applicationProperties;
        this.i18nBeanFactory = i18nBeanFactory;
        this.pluginAccessor = pluginAccessor;
        this.sprintManager = sprintManager;
        this.workflowService = workflowService;
        this.customFieldManager = customFieldManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.simplifiedWorkflowService = simplifiedWorkflowService;
        this.rankCustomFieldService = rankCustomFieldService;
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.rapidViewHelper = rapidViewHelper;
        this.rapidViewPresetService = rapidViewPresetService;
        this.columnService = columnService;
        this.issueFactory = issueFactory;
        this.issueTypeService = issueTypeService;
        this.projectService = projectService;
        this.epicCustomFieldService = epicCustomFieldService;
        this.lexoRankManager = lexoRankManager;
        this.versionService = versionService;
        this.mapper = new ObjectMapper();
        this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.orderedPriorityHelper = orderedPriorityHelper;
        this.issueIndexService = issueIndexService;
    }

    @Override
    public ServiceOutcome<Project> createSampleKanbanData(String projectKey, String projectName, Option<String> projectLeadUserName) {
        URL sampleDataUrl = this.pluginAccessor.getPlugin("com.pyxis.greenhopper.jira").getResource("sampledata/kanban.json");
        return this.importSampleDataFromUrl(projectKey, projectName, projectLeadUserName, SimplifiedWorkflowPresets.KANBAN_SIMPLIFIED_SAMPLE_WORKFLOW, sampleDataUrl, ProjectType.KANBAN);
    }

    @Override
    public ServiceOutcome<Project> createSampleScrumData(String projectKey, String projectName, Option<String> projectLeadUserName) {
        URL sampleDataUrl = this.pluginAccessor.getPlugin("com.pyxis.greenhopper.jira").getResource("sampledata/scrum.json");
        return this.importSampleDataFromUrl(projectKey, projectName, projectLeadUserName, SimplifiedWorkflowPresets.SIMPLIFIED_WORKFLOW, sampleDataUrl, ProjectType.SCRUM);
    }

    @Override
    public ServiceOutcome<Project> importSampleDataFromUrl(String projectKey, String projectName, Option<String> projectLeadUserName, SimplifiedWorkflowPresets projectWorkflow, URL sampleDataUrl, ProjectType projectType) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceOutcome<Pair<JiraWorkflow, Scheme>> workflowAndScheme = this.simplifiedWorkflowService.createSimplifiedWorkflowForNewProject(user, projectKey, projectWorkflow);
        if (!workflowAndScheme.isValid()) {
            return ServiceOutcomeImpl.error(workflowAndScheme);
        }
        ServiceOutcome<Project> sampleData = this.createSampleData(sampleDataUrl, projectKey, projectName, (String)projectLeadUserName.getOrElse((Object)user.getName()), user, (Scheme)workflowAndScheme.getValue().second(), projectType);
        if (!sampleData.isValid()) {
            ServiceOutcome<Void> outcome = this.workflowService.deleteScheme(((Scheme)workflowAndScheme.getValue().second()).getName());
            if (!outcome.isValid()) {
                this.log.warn(outcome.getErrors().toString(), new Object[0]);
            }
            if (!(outcome = this.workflowService.deleteWorkflow(((JiraWorkflow)workflowAndScheme.getValue().first()).getName())).isValid()) {
                this.log.warn(outcome.getErrors().toString(), new Object[0]);
            }
            return sampleData;
        }
        this.workflowService.associateSchemeToProject(sampleData.getValue(), (Scheme)workflowAndScheme.getValue().second());
        return sampleData;
    }

    @Override
    public ServiceOutcome<RapidView> createRapidViewWithProjects(String rapidViewName, RapidViewPreset rapidViewPreset, List<Project> projects) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceOutcome<RapidView> rapidView = this.rapidViewHelper.createRapidViewWithProjects(user, rapidViewName, rapidViewPreset, projects);
        if (rapidView.isValid()) {
            List<Column> columns = this.rapidViewPresetService.createColumnsForSimplifiedWorkflow(rapidViewPreset);
            this.columnService.updateColumns(user, rapidView.getValue(), columns);
        }
        return rapidView;
    }

    private ServiceOutcome<Project> createSampleData(URL sampleDataUrl, String projectKey, String projectName, String projectLeadUserName, ApplicationUser user, Scheme workflowScheme, ProjectType projectType) {
        SampleDataGeneratorComponentList generatorComponents = SampleDataGeneratorComponentList.of(new StatusGeneratorComponent(this.workflowService), new FieldGeneratorComponent(this.customFieldManager), new SprintGeneratorComponent(this.sprintManager), new EpicGeneratorComponent(this.issueFactory, this.issueTypeService, this.epicCustomFieldService, this.issueManager), new VersionGeneratorComponent(this.versionService), new IssueTypeGeneratorComponent(this.applicationProperties, this.i18nBeanFactory, this.issueTypeService), new PriorityGeneratorComponent(this.orderedPriorityHelper));
        ServiceOutcome<String> json = this.getJsonStringFromFile(sampleDataUrl, generatorComponents);
        if (!json.isValid()) {
            return ServiceOutcomeImpl.error(json);
        }
        Project initialProject = this.projectManager.getProjectObjByKey(projectKey);
        SampleDataCallbacks importCallbacks = new SampleDataCallbacks(projectType);
        if (initialProject == null && generatorComponents.isProjectRequired()) {
            ServiceOutcome<Project> projectServiceOutcome = this.projectService.createProject(user, projectName, projectKey, null, projectLeadUserName, null, 3L, null, projectType);
            if (projectServiceOutcome.isInvalid()) {
                this.log.warn("Could not create project '" + projectName + "'", new Object[0]);
            } else {
                initialProject = projectServiceOutcome.getValue();
                this.workflowService.associateSchemeToProject(initialProject, workflowScheme);
                importCallbacks = null;
            }
        }
        Map<String, Object> componentParams = generatorComponents.runBeforeImport(user, initialProject);
        Map<String, Object> velocityContext = this.generateVelocityContext(user, projectKey, projectName, projectLeadUserName, componentParams);
        this.log.info("Importing data with the following velocity context: " + velocityContext, new Object[0]);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        this.importer.createSampleData(json.getValue(), velocityContext, (Callbacks)importCallbacks, null, null, (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)errors);
        }
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        if (project == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.sampledata.error.project.not.found", projectKey);
        }
        generatorComponents.runAfterImport(user, project);
        ServiceOutcome<Void> rankOutcome = this.ensureIssuesRankedInOrder(project);
        if (!rankOutcome.isValid()) {
            this.log.warn(rankOutcome.getErrors().toString(), new Object[0]);
        }
        return ServiceOutcomeImpl.ok(project);
    }

    private ServiceOutcome<Void> ensureIssuesRankedInOrder(Project project) {
        try {
            CustomField defaultRankField = this.rankCustomFieldService.getDefaultRankField();
            ArrayList issueIds = new ArrayList(this.issueManager.getIssueIdsForProject(project.getId()));
            Collections.sort(issueIds);
            for (Long issueId : issueIds) {
                LexoRankOperationOutcome<LexoRankChange> rankOutcome;
                MutableIssue issueObject = this.issueManager.getIssueObject(issueId);
                if (issueObject.isSubTask() || !(rankOutcome = this.lexoRankManager.rankLast(defaultRankField.getIdAsLong(), issueId)).isValid()) continue;
                this.issueIndexService.reindexIssuesAndSubtasks(rankOutcome.getIssueIdsToReIndex());
            }
        }
        catch (GenericEntityException e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.sampledata.warning.could.not.rank", new Object[0]);
        }
        return ServiceOutcomeImpl.ok();
    }

    private Map<String, Object> generateVelocityContext(ApplicationUser user, String projectKey, String projectName, String projectLeadUserName, Map<String, Object> componentParams) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("projectKey", projectKey);
        context.put("projectName", projectName);
        context.put("currentUser", user.getName());
        context.put("projectLeadUserName", projectLeadUserName);
        context.putAll(componentParams);
        return context;
    }

    private ServiceOutcome<String> getJsonStringFromFile(URL sampleDataUrl, SampleDataGeneratorComponentList generatorComponents) {
        String output;
        try {
            InputStream inputStream = sampleDataUrl.openStream();
            JsonNode jsonNodes = this.mapper.readTree(inputStream);
            StringWriter jsonWriter = new StringWriter();
            JsonGenerator jsonGenerator = this.mapper.getJsonFactory().createJsonGenerator((Writer)jsonWriter);
            jsonGenerator.useDefaultPrettyPrinter();
            jsonGenerator.writeStartObject();
            Iterator fieldNames = jsonNodes.getFieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode fieldValue = jsonNodes.get(fieldName);
                if (fieldName.equals("ghsample")) {
                    generatorComponents.parseData(fieldValue);
                    continue;
                }
                jsonGenerator.writeObjectField(fieldName, (Object)fieldValue);
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.flush();
            output = jsonWriter.toString();
            jsonGenerator.close();
        }
        catch (IOException e) {
            this.log.exception(e);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.sampledata.error.reading.json", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(output);
    }

    private class SampleDataCallbacks
    extends Callbacks {
        private final ProjectType projectType;

        SampleDataCallbacks(ProjectType projectType) {
            this.projectType = projectType;
        }

        public void afterProjectCreated(ExternalProject externalProject, Project project) {
            SampleDataGeneratorImpl.this.agileProjectConfigurator.configure(project, this.projectType);
        }

        public void afterProjectCreated(ExternalProject externalProject, Project project, boolean newProject) {
            SampleDataGeneratorImpl.this.agileProjectConfigurator.configure(project, this.projectType);
        }
    }
}

