/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sampledata;

import com.atlassian.greenhopper.sampledata.SampleDataGeneratorComponent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonNode;

class SampleDataGeneratorComponentList
implements SampleDataGeneratorComponent {
    private final List<SampleDataGeneratorComponent> components;

    public static SampleDataGeneratorComponentList of(SampleDataGeneratorComponent ... components) {
        return new SampleDataGeneratorComponentList(Lists.newArrayList((Object[])components));
    }

    private SampleDataGeneratorComponentList(List<SampleDataGeneratorComponent> components) {
        this.components = components;
    }

    @Override
    public void parseData(JsonNode ghSampleNode) {
        for (SampleDataGeneratorComponent component : this.components) {
            component.parseData(ghSampleNode);
        }
    }

    @Override
    public boolean isProjectRequired() {
        return Iterables.any(this.components, (Predicate)new Predicate<SampleDataGeneratorComponent>(){

            public boolean apply(SampleDataGeneratorComponent component) {
                return component.isProjectRequired();
            }
        });
    }

    @Override
    public Map<String, Object> runBeforeImport(ApplicationUser currentUser, @Nullable Project project) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (SampleDataGeneratorComponent component : this.components) {
            params.putAll(component.runBeforeImport(currentUser, (Project)(component.isProjectRequired() ? project : null)));
        }
        return params;
    }

    @Override
    public void runAfterImport(ApplicationUser currentUser, Project project) {
        for (SampleDataGeneratorComponent component : this.components) {
            component.runAfterImport(currentUser, project);
        }
    }
}

