/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sampledata;

import com.atlassian.greenhopper.issue.util.OrderedPriorityHelper;
import com.atlassian.greenhopper.sampledata.SampleDataGeneratorComponent;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import io.atlassian.fugue.Option;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonNode;

class PriorityGeneratorComponent
implements SampleDataGeneratorComponent {
    private static final String CRITICAL = new String("Critical");
    private static final String MEDIUM = new String("Medium");
    private final OrderedPriorityHelper orderedPriorityHelper;

    public PriorityGeneratorComponent(OrderedPriorityHelper orderedPriorityHelper) {
        this.orderedPriorityHelper = orderedPriorityHelper;
    }

    @Override
    public void parseData(JsonNode ghSampleNode) {
    }

    @Override
    public boolean isProjectRequired() {
        return false;
    }

    @Override
    public Map<String, Object> runBeforeImport(ApplicationUser currentUser, @Nullable Project project) {
        Option<Priority> highestPriority = this.orderedPriorityHelper.getHighestPriority();
        String highestPriorityName = CRITICAL;
        if (highestPriority.isDefined()) {
            highestPriorityName = (String)Option.option((Object)((Priority)highestPriority.get()).getName()).getOrElse((Object)CRITICAL);
        }
        Option<Priority> middlePriority = this.orderedPriorityHelper.getMiddlePriority();
        String examplePriorityName = MEDIUM;
        if (middlePriority.isDefined()) {
            examplePriorityName = (String)Option.option((Object)((Priority)middlePriority.get()).getName()).getOrElse((Object)MEDIUM);
        }
        return MapBuilder.newBuilder().add((Object)"highestPriority", (Object)highestPriorityName).add((Object)"examplePriority", (Object)examplePriorityName).toMap();
    }

    @Override
    public void runAfterImport(ApplicationUser currentUser, Project project) {
    }
}

