/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sampledata;

import com.atlassian.greenhopper.sampledata.SampleDataGeneratorComponent;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.codehaus.jackson.JsonNode;

public class IssueTypeGeneratorComponent
implements SampleDataGeneratorComponent {
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final IssueTypeService issueTypeService;

    public IssueTypeGeneratorComponent(ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nBeanFactory, IssueTypeService issueTypeService) {
        this.applicationProperties = applicationProperties;
        this.i18nBeanFactory = i18nBeanFactory;
        this.issueTypeService = issueTypeService;
    }

    @Override
    public void parseData(JsonNode ghSampleNode) {
    }

    @Override
    public boolean isProjectRequired() {
        return false;
    }

    @Override
    public Map<String, Object> runBeforeImport(ApplicationUser currentUser, Project project) {
        HashMap params = Maps.newHashMap();
        Locale locale = this.applicationProperties.getDefaultLocale();
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance(locale);
        this.addParam((Map<String, Object>)params, "epic", this.issueTypeService.getOrCreateEpicIssueType().getName());
        this.addParam((Map<String, Object>)params, "story", this.issueTypeService.getOrCreateStoryIssueType().getName());
        this.addParam((Map<String, Object>)params, i18nHelper, "bug");
        this.addParam((Map<String, Object>)params, i18nHelper, "improvement");
        this.addParam((Map<String, Object>)params, i18nHelper, "newfeature");
        this.addParam((Map<String, Object>)params, i18nHelper, "sub-task");
        this.addParam((Map<String, Object>)params, i18nHelper, "task");
        return params;
    }

    private void addParam(Map<String, Object> params, I18nHelper i18nHelper, String issueTypeKey) {
        String fullKey = "jira.translation.issuetype." + issueTypeKey + ".name";
        String issueTypeName = i18nHelper.getText(fullKey);
        this.addParam(params, issueTypeKey, issueTypeName);
    }

    private void addParam(Map<String, Object> params, String issueTypeKey, String issueTypeName) {
        params.put("issueType_" + issueTypeKey, issueTypeName);
    }

    @Override
    public void runAfterImport(ApplicationUser currentUser, Project project) {
    }
}

