/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sampledata;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.sampledata.SampleDataGeneratorComponent;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonNode;

class FieldGeneratorComponent
implements SampleDataGeneratorComponent {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private final CustomFieldManager customFieldManager;
    private final Map<String, Object> fieldMapping = new HashMap<String, Object>();

    public FieldGeneratorComponent(CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
    }

    @Override
    public void parseData(JsonNode ghSampleNode) {
        JsonNode fieldsNode = ghSampleNode.get("fields");
        if (fieldsNode == null) {
            return;
        }
        Iterator fieldNames = fieldsNode.getFieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            CustomField customField = this.customFieldManager.getCustomFieldObjectByName(fieldsNode.get(fieldName).getTextValue());
            if (customField == null) {
                this.log.warn("Custom field with name " + fieldName + " could not be found, but was expected by sample data", new Object[0]);
                continue;
            }
            this.fieldMapping.put(fieldName, customField.getId());
        }
    }

    @Override
    public boolean isProjectRequired() {
        return false;
    }

    @Override
    public Map<String, Object> runBeforeImport(ApplicationUser currentUser, @Nullable Project project) {
        return this.fieldMapping;
    }

    @Override
    public void runAfterImport(ApplicationUser currentUser, Project project) {
    }
}

