/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sampledata;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.sampledata.SampleDataGeneratorComponent;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

class EpicGeneratorComponent
implements SampleDataGeneratorComponent {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private final IssueFactory issueFactory;
    private final IssueTypeService issueTypeService;
    private final EpicCustomFieldService epicCustomFieldService;
    private IssueManager issueManager;
    private final Map<String, EpicData> epicDataMap = new HashMap<String, EpicData>();

    public EpicGeneratorComponent(IssueFactory issueFactory, IssueTypeService issueTypeService, EpicCustomFieldService epicCustomFieldService, IssueManager issueManager) {
        this.issueFactory = issueFactory;
        this.issueTypeService = issueTypeService;
        this.epicCustomFieldService = epicCustomFieldService;
        this.issueManager = issueManager;
    }

    @Override
    public void parseData(JsonNode ghSampleNode) {
        JsonNode epicsNode = ghSampleNode.get("epics");
        if (epicsNode == null) {
            return;
        }
        Iterator fieldNames = epicsNode.getFieldNames();
        DateTime now = new DateTime();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            this.epicDataMap.put(fieldName, this.parseEpic(now, epicsNode.get(fieldName)));
        }
    }

    @Override
    public boolean isProjectRequired() {
        return !this.epicDataMap.isEmpty();
    }

    @Override
    public Map<String, Object> runBeforeImport(ApplicationUser currentUser, Project project) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String epicVar : this.epicDataMap.keySet()) {
            EpicData epicData = this.epicDataMap.get(epicVar);
            this.log.info("Creating epic with label '" + epicData.getEpicLabel() + "'", new Object[0]);
            MutableIssue issue = this.issueFactory.getIssue();
            issue.setProjectObject(project);
            issue.setIssueTypeObject(this.issueTypeService.getOrCreateEpicIssueType());
            issue.setSummary(epicData.getEpicLabel());
            issue.setReporter(currentUser);
            issue.setCustomFieldValue(this.epicCustomFieldService.getDefaultEpicLabelField(), (Object)epicData.getEpicLabel());
            if (epicData.getCreated() != null) {
                issue.setCreated(new Timestamp(epicData.getCreated().getMillis()));
            }
            try {
                Issue epic = this.issueManager.createIssueObject(currentUser, (Issue)issue);
                params.put(epicVar + "_key", epic.getKey());
                params.put(epicVar + "_id", epic.getId());
            }
            catch (CreateException e) {
                this.log.warn("Could not create sample data epic: " + (Object)((Object)e), new Object[0]);
                throw new RuntimeException(e);
            }
        }
        return params;
    }

    @Override
    public void runAfterImport(ApplicationUser currentUser, Project project) {
    }

    private EpicData parseEpic(DateTime now, JsonNode epicJson) {
        JsonNode labelNode;
        JsonNode createdNode = epicJson.get("created");
        DateTime created = null;
        if (createdNode != null) {
            Period period = Period.parse((String)createdNode.getTextValue());
            created = now.plus((ReadablePeriod)period);
        }
        String label = (labelNode = epicJson.get("label")) == null ? null : labelNode.getTextValue();
        return new EpicData(created, label);
    }

    private static class EpicData {
        private final DateTime created;
        private final String epicLabel;

        EpicData(DateTime created, String epicLabel) {
            this.created = created;
            this.epicLabel = epicLabel;
        }

        public DateTime getCreated() {
            return this.created;
        }

        public String getEpicLabel() {
            return this.epicLabel;
        }
    }
}

