/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.rest;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.ApplicationUserBestNameComparator;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="gh-assigneeUserPickerSearchService")
public class AssigneeUserPickerSearchService {
    public static final String SERVICE = "gh-assigneeUserPickerSearchService";
    private static final String RUNNING_ASSIGNEE_PICKER_SEARCH = "Running assignee-picker search: ";
    @Autowired
    private PermissionContextFactory permissionContextFactory;
    @Autowired
    private PermissionSchemeManager permissionSchemeManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private PermissionManager permissionManager;
    @Autowired
    private ApplicationProperties applicationProperties;
    private static final String VISIBILITY_PUBLIC = "show";
    private static final String VISIBILITY_USER = "user";
    private static final String VISIBILITY_MASKED = "mask";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApplicationUser> findAssignableUsers(ApplicationUser currentUser, Issue issue, Project project, String query) {
        if (!this.canPerformAjaxSearch(currentUser)) {
            return Collections.emptyList();
        }
        String convertedQuery = query == null ? "" : query;
        UtilTimerStack.push((String)(RUNNING_ASSIGNEE_PICKER_SEARCH + convertedQuery));
        try {
            ArrayList<ApplicationUser> returnUsers = new ArrayList<ApplicationUser>();
            boolean canShowEmailAddresses = this.canShowEmailAddresses(currentUser);
            Collection<ApplicationUser> allUsers = issue != null ? this.getAllAssignableUsers(issue) : this.getAllAssignableUsers(project);
            for (ApplicationUser user : allUsers) {
                if (!this.userMatches(user, convertedQuery, canShowEmailAddresses)) continue;
                returnUsers.add(user);
            }
            Locale userLocale = I18nBean.getLocaleFromUser((ApplicationUser)currentUser);
            Collections.sort(returnUsers, new ApplicationUserBestNameComparator(userLocale));
            ArrayList<ApplicationUser> arrayList = returnUsers;
            return arrayList;
        }
        finally {
            UtilTimerStack.pop((String)(RUNNING_ASSIGNEE_PICKER_SEARCH + convertedQuery));
        }
    }

    public boolean canPerformAjaxSearch(ApplicationUser currentUser) {
        return this.permissionManager.hasPermission(27, currentUser);
    }

    public boolean canShowEmailAddresses(ApplicationUser currentUser) {
        String emailVisibility;
        return this.canPerformAjaxSearch(currentUser) && (VISIBILITY_PUBLIC.equals(emailVisibility = this.applicationProperties.getDefaultBackedString("jira.option.emailvisible")) || VISIBILITY_MASKED.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && currentUser != null);
    }

    private boolean userMatches(ApplicationUser user, String query, boolean canShowEmailAddresses) {
        query = query.toLowerCase().trim();
        String userPart = user.getName();
        if (StringUtils.isNotBlank((CharSequence)userPart) && userPart.toLowerCase().startsWith(query)) {
            return true;
        }
        if (canShowEmailAddresses && StringUtils.isNotBlank((CharSequence)(userPart = user.getEmailAddress())) && userPart.toLowerCase().startsWith(query)) {
            return true;
        }
        userPart = user.getDisplayName();
        if (StringUtils.isNotBlank((CharSequence)userPart)) {
            if (userPart.toLowerCase().startsWith(query)) {
                return true;
            }
            StringTokenizer tokenizer = new StringTokenizer(userPart.toLowerCase());
            while (tokenizer.hasMoreElements()) {
                userPart = tokenizer.nextToken();
                if (!userPart.startsWith(query)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<ApplicationUser> getAllAssignableUsers(Issue issue) {
        PermissionContext ctx = this.permissionContextFactory.getPermissionContext(issue);
        return this.getAllAssignableUsers(ctx);
    }

    private Collection<ApplicationUser> getAllAssignableUsers(Project project) {
        PermissionContext ctx = this.permissionContextFactory.getPermissionContext(project);
        return this.getAllAssignableUsers(ctx);
    }

    private Collection<ApplicationUser> getAllAssignableUsers(PermissionContext permissionContext) {
        Collection users = this.permissionSchemeManager.getUsers(Long.valueOf(17L), permissionContext);
        HashMap<String, ApplicationUser> uniqueUsers = new HashMap<String, ApplicationUser>();
        for (ApplicationUser user : users) {
            if (uniqueUsers.containsKey(user.getName())) {
                ApplicationUser realUser = this.userManager.getUserByName(user.getName());
                uniqueUsers.put(user.getName(), realUser);
                continue;
            }
            uniqueUsers.put(user.getName(), user);
        }
        return uniqueUsers.values();
    }

    public boolean isUnassignedIssuesEnabled() {
        return this.applicationProperties.getOption("jira.option.allowunassigned");
    }
}

