/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.rest;

import com.atlassian.greenhopper.rest.AssigneeUserPickerSearchService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.DelimeterInserter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="assignees/picker")
@AnonymousAllowed
@Produces(value={"application/json", "application/xml"})
public class AssigneeUserPickerResource
extends AbstractResource {
    private final JiraAuthenticationContext authContext;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper i18nHelper;
    private final AssigneeUserPickerSearchService assigneeUserPickerHelper;
    private final ProjectService projectService;
    private final AvatarService avatarService;
    private final IssueService issueService;

    public AssigneeUserPickerResource(JiraAuthenticationContext authContext, I18nHelper.BeanFactory i18nBeanFactory, ApplicationProperties applicationProperties, AssigneeUserPickerSearchService assigneeUserPickerHelper, ProjectService projectService, AvatarService avatarService, IssueService issueService) {
        this.authContext = authContext;
        this.applicationProperties = applicationProperties;
        this.assigneeUserPickerHelper = assigneeUserPickerHelper;
        this.projectService = projectService;
        this.avatarService = avatarService;
        this.i18nHelper = i18nBeanFactory.getInstance(authContext.getUser());
        this.issueService = issueService;
    }

    @GET
    public Response getUsersResponse(final @QueryParam(value="fieldName") String fieldName, final @QueryParam(value="query") String query, final @QueryParam(value="issueId") Long issueId, final @QueryParam(value="issueKey") String issueKey, final @QueryParam(value="projectId") Long projectId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                return Response.ok((Object)AssigneeUserPickerResource.this.getUsers(fieldName, query, issueId, issueKey, projectId)).cacheControl(CacheControl.NO_CACHE).build();
            }
        });
    }

    public UserPickerResultsWrapper getUsers(String fieldName, String query, Long issueId, String issueKey, Long projectId) {
        String automaticText;
        String unassignedText;
        ProjectService.GetProjectResult projectResult;
        IssueService.IssueResult issueResult;
        JiraServiceContext jiraServiceCtx = this.getContext();
        UserPickerResultsWrapper results = new UserPickerResultsWrapper();
        if (!this.assigneeUserPickerHelper.canPerformAjaxSearch(jiraServiceCtx.getLoggedInApplicationUser())) {
            return results;
        }
        ApplicationUser currentUser = jiraServiceCtx.getLoggedInApplicationUser();
        MutableIssue issue = null;
        Project project = null;
        if (issueId != null && (issueResult = this.issueService.getIssue(currentUser, issueId)).isValid()) {
            issue = issueResult.getIssue();
        }
        if (issue == null && issueKey != null && (issueResult = this.issueService.getIssue(currentUser, issueKey)).isValid()) {
            issue = issueResult.getIssue();
        }
        if (issue == null && projectId != null && (projectResult = this.projectService.getProjectById(currentUser, projectId)).isValid()) {
            project = projectResult.getProject();
        }
        if (issue == null && project == null) {
            return results;
        }
        String lowerCaseQuery = query.toLowerCase().trim();
        if (this.assigneeUserPickerHelper.isUnassignedIssuesEnabled() && (unassignedText = this.i18nHelper.getText("common.concepts.unassigned")).toLowerCase().startsWith(lowerCaseQuery)) {
            String html = this.formatGenericOption(fieldName, unassignedText, query);
            results.addUser(new UserPickerUser("", html, "", unassignedText));
        }
        if ((automaticText = this.i18nHelper.getText("gh.boards.autoassign")).toLowerCase().startsWith(lowerCaseQuery)) {
            String optionHtml = this.formatGenericOption(fieldName, automaticText, query);
            results.addUser(new UserPickerUser("-1", optionHtml, "", automaticText));
        }
        boolean canShowEmailAddresses = this.assigneeUserPickerHelper.canShowEmailAddresses(currentUser);
        int limit = this.getLimit();
        int count = 0;
        List<ApplicationUser> users = this.assigneeUserPickerHelper.findAssignableUsers(currentUser, (Issue)issue, project, query);
        for (ApplicationUser user : users) {
            if (count >= limit) break;
            String userHtml = this.formatUser(fieldName, user, query, canShowEmailAddresses);
            results.addUser(new UserPickerUser(user.getName(), userHtml, this.avatarService.getAvatarURL(currentUser, user, Avatar.Size.SMALL).toString(), user.getDisplayName()));
            ++count;
        }
        results.setFooter(this.i18nHelper.getText("jira.ajax.autocomplete.user.more.results", String.valueOf(count), String.valueOf(users.size())));
        return results;
    }

    private String getElementId(String fieldName, String type, String field) {
        return " id=\"" + fieldName + "_" + type + "_" + field + "\" ";
    }

    private int getLimit() {
        int limit = 20;
        try {
            limit = Integer.valueOf(this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        catch (Exception nfe) {
            this.log.error("jira.ajax.autocomplete.limit does not exist or is an invalid number in jira-application.properties.", nfe);
        }
        return limit;
    }

    private String formatGenericOption(String fieldName, String text, String query) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<b>", "</b>");
        String[] terms = new String[]{query};
        String htmlText = delimeterInserter.insert(TextUtils.htmlEncode((String)text), terms);
        StringBuffer sb = new StringBuffer();
        sb.append("<div ");
        sb.append(this.getElementId(fieldName, "i", TextUtils.htmlEncode((String)text)));
        sb.append("class=\"yad\" ");
        sb.append(">");
        sb.append(htmlText);
        sb.append("</div>");
        return sb.toString();
    }

    private String formatUser(String fieldName, ApplicationUser user, String query, boolean canShoweEmailAddresses) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<b>", "</b>");
        String[] terms = new String[]{query};
        String userFullName = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getDisplayName()), terms);
        String userName = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getName()), terms);
        StringBuffer sb = new StringBuffer();
        sb.append("<div ");
        sb.append(this.getElementId(fieldName, "i", TextUtils.htmlEncode((String)user.getName())));
        sb.append("class=\"yad\" ");
        sb.append(">");
        sb.append(userFullName);
        if (canShoweEmailAddresses) {
            String userEmail = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getEmailAddress()), terms);
            sb.append("&nbsp;-&nbsp;");
            sb.append(userEmail);
        }
        sb.append("&nbsp;(");
        sb.append(userName);
        sb.append(")");
        sb.append("</div>");
        return sb.toString();
    }

    JiraServiceContext getContext() {
        ApplicationUser user = this.authContext.getUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return new JiraServiceContextImpl(user, (ErrorCollection)errorCollection);
    }

    @XmlRootElement
    public static class UserPickerUser {
        @XmlElement
        private String name;
        @XmlElement
        private String html;
        @XmlElement
        private String avatarUrl;
        @XmlElement
        private String displayName;

        private UserPickerUser() {
        }

        public UserPickerUser(String name, String html, String avatarUrl, String displayName) {
            this.name = name;
            this.html = html;
            this.avatarUrl = avatarUrl;
            this.displayName = displayName;
        }
    }

    @XmlRootElement
    public static class UserPickerResultsWrapper {
        @XmlElement
        private List<UserPickerUser> users;
        @XmlElement
        private String footer;

        private UserPickerResultsWrapper() {
        }

        public UserPickerResultsWrapper(List<UserPickerUser> users, String footer) {
            this.users = users;
            this.footer = footer;
        }

        public void addUser(UserPickerUser user) {
            if (this.users == null) {
                this.users = new ArrayList<UserPickerUser>();
            }
            this.users.add(user);
        }

        public void setFooter(String footer) {
            this.footer = footer;
        }
    }
}

