/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.project;

import com.atlassian.greenhopper.project.InitialPermissionSchemeFactory;
import com.atlassian.greenhopper.project.PermissionSchemeProjectCreateHandler;
import com.atlassian.greenhopper.project.SoftwareProjectTypeService;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCreatedData;
import com.atlassian.jira.scheme.Scheme;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionSchemeProjectCreateHandlerImpl
implements PermissionSchemeProjectCreateHandler {
    private final PermissionSchemeManager permissionSchemeManager;
    private final SoftwareProjectTypeService softwareProjectTypeService;
    private final InitialPermissionSchemeFactory initialPermissionSchemeFactory;
    private final ApplicationRoleManager applicationRoleManager;

    @Autowired
    public PermissionSchemeProjectCreateHandlerImpl(PermissionSchemeManager permissionSchemeManager, SoftwareProjectTypeService softwareProjectTypeService, InitialPermissionSchemeFactory initialPermissionSchemeFactory, ApplicationRoleManager applicationRoleManager) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.softwareProjectTypeService = softwareProjectTypeService;
        this.initialPermissionSchemeFactory = initialPermissionSchemeFactory;
        this.applicationRoleManager = applicationRoleManager;
    }

    public String getHandlerId() {
        return PermissionSchemeProjectCreateHandlerImpl.class.getName() + ".ProjectCreateHandler";
    }

    public void onProjectCreated(ProjectCreatedData projectCreatedData) throws CreateException {
        Project project = projectCreatedData.getProject();
        if (this.applicationRoleManager.rolesEnabled() && projectCreatedData.getType().equals((Object)ProjectCreatedData.Type.CREATE) && this.softwareProjectTypeService.isSoftwareProject(project)) {
            this.addPermissionScheme(project);
        }
    }

    public void onProjectCreationRolledBack(ProjectCreatedData projectCreatedData) {
    }

    private void addPermissionScheme(Project project) {
        Scheme newPermissionScheme = this.initialPermissionSchemeFactory.getScheme();
        if (newPermissionScheme != null) {
            this.associateProjectToNewScheme(project, newPermissionScheme);
        }
    }

    private void associateProjectToNewScheme(Project project, Scheme newPermissionScheme) {
        this.permissionSchemeManager.removeSchemesFromProject(project);
        this.permissionSchemeManager.addSchemeToProject(project, newPermissionScheme);
    }
}

