/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.project;

import com.atlassian.greenhopper.jira.permission.GHProjectPermissions;
import com.atlassian.greenhopper.project.SoftwarePermissionSchemeData;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.permission.PermissionSchemeInput;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DefaultSoftwarePermissionSchemeData
implements SoftwarePermissionSchemeData {
    private static final List<Pair<RoleHolder, ProjectPermissionKey>> PERMISSION_LIST = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.BROWSE_PROJECTS), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.CREATE_ISSUES), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.EDIT_ISSUES), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.ASSIGN_ISSUES), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.RESOLVE_ISSUES), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.ADD_COMMENTS), Pair.of((Object)((Object)RoleHolder.ADMIN), (Object)ProjectPermissions.DELETE_ISSUES), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.ASSIGNABLE_USER), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.CLOSE_ISSUES), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.CREATE_ATTACHMENTS), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.WORK_ON_ISSUES), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.LINK_ISSUES), Pair.of((Object)((Object)RoleHolder.ADMIN), (Object)ProjectPermissions.ADMINISTER_PROJECTS), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.MOVE_ISSUES), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.SCHEDULE_ISSUES), Pair.of((Object)((Object)RoleHolder.ADMIN), (Object)ProjectPermissions.MODIFY_REPORTER), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.VIEW_VOTERS_AND_WATCHERS), Pair.of((Object)((Object)RoleHolder.ADMIN), (Object)ProjectPermissions.MANAGE_WATCHERS), Pair.of((Object)((Object)RoleHolder.ADMIN), (Object)ProjectPermissions.EDIT_ALL_COMMENTS), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.EDIT_OWN_COMMENTS), Pair.of((Object)((Object)RoleHolder.ADMIN), (Object)ProjectPermissions.DELETE_ALL_COMMENTS), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.DELETE_OWN_COMMENTS), Pair.of((Object)((Object)RoleHolder.ADMIN), (Object)ProjectPermissions.DELETE_ALL_ATTACHMENTS), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.DELETE_OWN_ATTACHMENTS), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.EDIT_OWN_WORKLOGS), Pair.of((Object)((Object)RoleHolder.ADMIN), (Object)ProjectPermissions.EDIT_ALL_WORKLOGS), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.DELETE_OWN_WORKLOGS), Pair.of((Object)((Object)RoleHolder.ADMIN), (Object)ProjectPermissions.DELETE_ALL_WORKLOGS), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.VIEW_READONLY_WORKFLOW), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.TRANSITION_ISSUES), Pair.of((Object)((Object)RoleHolder.USER), (Object)ProjectPermissions.VIEW_DEV_TOOLS), Pair.of((Object)((Object)RoleHolder.USER), (Object)GHProjectPermissions.MANAGE_SPRINTS)});

    @Override
    @VisibleForTesting
    public PermissionSchemeInput getSchemeInput(String schemeName, String schemeDesc, final PermissionHolder adminRoleHolder, final PermissionHolder userRoleHolder) {
        PermissionSchemeInput.Builder permissionSchemeBuilder = PermissionSchemeInput.builder((String)schemeName);
        permissionSchemeBuilder.setDescription(schemeDesc);
        permissionSchemeBuilder.addPermissions((Iterable)Lists.transform(this.getPermissionList(), (Function)new Function<Pair, PermissionGrantInput>(){

            public PermissionGrantInput apply(Pair input) {
                if (RoleHolder.USER.equals(input.first())) {
                    return PermissionGrantInput.newGrant((PermissionHolder)userRoleHolder, (ProjectPermissionKey)((ProjectPermissionKey)input.second()));
                }
                if (RoleHolder.ADMIN.equals(input.first())) {
                    return PermissionGrantInput.newGrant((PermissionHolder)adminRoleHolder, (ProjectPermissionKey)((ProjectPermissionKey)input.second()));
                }
                throw new IllegalArgumentException("Unsupported RoleHolder type in the permissions list.");
            }
        }));
        return permissionSchemeBuilder.build();
    }

    @VisibleForTesting
    List<Pair<RoleHolder, ProjectPermissionKey>> getPermissionList() {
        return PERMISSION_LIST;
    }

    protected static enum RoleHolder {
        USER,
        ADMIN;

    }
}

