/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.project;

import com.atlassian.greenhopper.project.InitialPermissionSchemeFactory;
import com.atlassian.greenhopper.project.SoftwarePermissionSchemeData;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeInput;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeService;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.data.CustomPermissionHolderType;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultInitialPermissionSchemeFactory
implements InitialPermissionSchemeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInitialPermissionSchemeFactory.class);
    private static final String DEFAULT_PERMISSION_SCHEME_ID = "com.pyxis.greenhopper.jira:default.permission.scheme.id";
    private static final long USER_ROLE_ID = 10000L;
    private static final long ADMIN_ROLE_ID = 10002L;
    private static final String APPLICATION_ROLE = "applicationRole";
    private final ProjectRoleManager projectRoleManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionSchemeService permissionSchemeService;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final PermissionTypeManager permissionTypeManager;
    private final SoftwarePermissionSchemeData softwarePermissionSchemeData;

    @Autowired
    public DefaultInitialPermissionSchemeFactory(ProjectRoleManager projectRoleManager, PermissionSchemeManager permissionSchemeManager, PermissionSchemeService permissionSchemeService, PluginSettingsFactory pluginSettingsFactory, JiraAuthenticationContext authenticationContext, I18nHelper.BeanFactory i18nBeanFactory, SoftwarePermissionSchemeData softwarePermissionSchemeData) {
        this(projectRoleManager, permissionSchemeManager, permissionSchemeService, pluginSettingsFactory, authenticationContext, i18nBeanFactory, (PermissionTypeManager)ComponentAccessor.getComponent(PermissionTypeManager.class), softwarePermissionSchemeData);
    }

    @VisibleForTesting
    DefaultInitialPermissionSchemeFactory(ProjectRoleManager projectRoleManager, PermissionSchemeManager permissionSchemeManager, PermissionSchemeService permissionSchemeService, PluginSettingsFactory pluginSettingsFactory, JiraAuthenticationContext authenticationContext, I18nHelper.BeanFactory i18nBeanFactory, PermissionTypeManager permissionTypeManager, SoftwarePermissionSchemeData softwarePermissionSchemeData) {
        this.projectRoleManager = projectRoleManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.permissionSchemeService = permissionSchemeService;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.authenticationContext = authenticationContext;
        this.i18nBeanFactory = i18nBeanFactory;
        this.permissionTypeManager = permissionTypeManager;
        this.softwarePermissionSchemeData = softwarePermissionSchemeData;
    }

    @Override
    public Scheme getScheme() {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Scheme scheme = this.getCurrentScheme(pluginSettings);
        return scheme != null ? scheme : this.getNewScheme(pluginSettings);
    }

    private Scheme getNewScheme(PluginSettings pluginSettings) {
        PermissionScheme newScheme = this.createScheme();
        if (newScheme != null) {
            pluginSettings.put(DEFAULT_PERMISSION_SCHEME_ID, (Object)String.valueOf(newScheme.getId()));
            return this.asScheme(newScheme);
        }
        return null;
    }

    private Scheme getCurrentScheme(PluginSettings pluginSettings) {
        String defaultPermissionSchemeIdAsString = (String)pluginSettings.get(DEFAULT_PERMISSION_SCHEME_ID);
        if (defaultPermissionSchemeIdAsString != null) {
            Long id = Long.valueOf(defaultPermissionSchemeIdAsString);
            ServiceOutcome schemeOutcome = this.permissionSchemeService.getPermissionScheme(this.authenticationContext.getLoggedInUser(), id);
            if (schemeOutcome.get() != null) {
                return this.asScheme((PermissionScheme)schemeOutcome.get());
            }
        }
        return null;
    }

    private Scheme asScheme(PermissionScheme permissionScheme) {
        return this.permissionSchemeManager.getSchemeObject(permissionScheme.getId());
    }

    private PermissionScheme createScheme() {
        I18nHelper i18n = this.i18nBeanFactory.getInstance((ApplicationUser)null);
        String schemeName = this.getNewSchemeName(i18n);
        String schemeDesc = this.getSchemeDescription(i18n);
        PermissionHolder adminRoleHolder = this.getAdminRoleHolder();
        PermissionHolder userRoleHolder = this.getUserRoleHolder();
        if (adminRoleHolder == null || userRoleHolder == null) {
            return null;
        }
        PermissionSchemeInput input = this.softwarePermissionSchemeData.getSchemeInput(schemeName, schemeDesc, adminRoleHolder, userRoleHolder);
        ServiceOutcome createSchemeOutcome = this.permissionSchemeService.createPermissionScheme(this.authenticationContext.getLoggedInUser(), input);
        if (!createSchemeOutcome.isValid()) {
            LOG.warn("Unable to create the default Permission Scheme for JIRA agile");
            for (String string : createSchemeOutcome.getErrorCollection().getErrorMessages()) {
                LOG.warn(string);
            }
            for (Map.Entry entry : createSchemeOutcome.getErrorCollection().getErrors().entrySet()) {
                LOG.warn((String)entry.getKey() + " : " + (String)entry.getValue());
            }
            return null;
        }
        return (PermissionScheme)createSchemeOutcome.get();
    }

    private String getNewSchemeName(I18nHelper i18n) {
        String schemeNameBase;
        String schemeName = schemeNameBase = i18n.getText("jira.software.default.permission.scheme.name");
        try {
            int retry = 1;
            while (this.permissionSchemeManager.schemeExists(schemeName)) {
                if (retry >= 10) {
                    LOG.warn("Unable to create the default Software Permission Scheme : Can't generate a unique scheme name. Will try using : " + schemeName);
                    break;
                }
                schemeName = schemeNameBase + " - " + retry;
                ++retry;
            }
        }
        catch (GenericEntityException e) {
            LOG.warn("Exception thrown while generating a name for the default Software Permission Scheme. Will try using : " + schemeName);
            LOG.warn(e.getMessage());
        }
        return schemeName;
    }

    private String getSchemeDescription(I18nHelper i18n) {
        return i18n.getText("jira.software.default.permission.scheme.description");
    }

    private PermissionHolder getUserRoleHolder() {
        if (this.permissionTypeManager.getTypes().containsKey(APPLICATION_ROLE)) {
            return PermissionHolder.holder((PermissionHolderType)CustomPermissionHolderType.permissionHolderType((String)APPLICATION_ROLE, null));
        }
        ProjectRole userRole = this.projectRoleManager.getProjectRole(Long.valueOf(10000L));
        if (userRole != null) {
            return PermissionHolder.holder((PermissionHolderType)JiraPermissionHolderType.PROJECT_ROLE, (String)String.valueOf(userRole.getId()));
        }
        LOG.warn("Default User Project Role is not available. The default Permission Scheme for JIRA Software could not be created");
        return null;
    }

    private PermissionHolder getAdminRoleHolder() {
        ProjectRole adminRole = this.projectRoleManager.getProjectRole(Long.valueOf(10002L));
        if (adminRole != null) {
            return PermissionHolder.holder((PermissionHolderType)JiraPermissionHolderType.PROJECT_ROLE, (String)String.valueOf(adminRole.getId()));
        }
        LOG.warn("Default Administrator Project Role is not available. The default Permission Scheme for JIRA Software could not be created");
        return null;
    }
}

