/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.plugin.module;

import com.atlassian.greenhopper.plugin.module.ModuleContext;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public enum ModuleDefinition {
    GADGETS("modules/gadgets.xml"),
    RESOURCE_CHOOSE_LANGUAGE_SEQUENCE("modules/choose-language-sequence.xml"),
    PROJECT_TEMPLATES("modules/project-templates.xml"),
    SIDEBAR_INTEGRATION("modules/sidebar-integration.xml"),
    MAU_EVENT_TRACKING("modules/mau-event-tracking.xml", (Predicate<ModuleContext>)((Predicate)t -> ModuleDefinition.requireService("com.atlassian.jira.web.filters.mau.AbstractMauRequestTaggingFilter"))),
    AGILE_REPORTS("modules/agile-reports.xml"),
    DASHBOARD_ITEMS("modules/dashboard-items.xml"),
    ONBOARDING("modules/onboarding.xml", (Predicate<ModuleContext>)((Predicate)t -> ModuleDefinition.requireService("com.atlassian.jira.onboarding.FirstUseFlow")), RESOURCE_CHOOSE_LANGUAGE_SEQUENCE),
    PROJECT_IMPORT("modules/project-import.xml"),
    KEYBOARD_SHORTCUTS("modules/keyboard-shortcuts.xml"),
    DEMO_DATA("modules/demo-data.xml", (Predicate<ModuleContext>)((Predicate)t -> ModuleDefinition.requireService("com.atlassian.jira.project.template.descriptor.DemoProjectModuleDescriptor"))),
    DATA_IMPORT_VALIDATORS("modules/data-import-validators.xml", (Predicate<ModuleContext>)((Predicate)t -> ModuleDefinition.requireService("com.atlassian.jira.bc.dataimport.DataImportOSPropertyValidatorModuleDescriptor")));

    private String fileName;
    private Predicate<ModuleContext> isEnabled;
    private List<ModuleDefinition> dependencies;

    private ModuleDefinition(String fileName) {
        this(fileName, (Predicate<ModuleContext>)((Predicate)t -> true));
    }

    private ModuleDefinition(String filename, Predicate<ModuleContext> enabled) {
        this(filename, enabled, null);
    }

    private ModuleDefinition(String fileName, Predicate<ModuleContext> enabled, ModuleDefinition ... dependencies) {
        this.fileName = fileName;
        this.isEnabled = enabled;
        this.dependencies = dependencies != null ? Lists.newArrayList((Object[])dependencies) : Collections.emptyList();
    }

    private static boolean requireService(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static List<ModuleDefinition> getDefinitionsForContext(ModuleContext ctx) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])ModuleDefinition.values()), md -> md.isApplicable(ctx)));
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<ModuleDefinition> getDependencies() {
        return this.dependencies;
    }

    public boolean isApplicable(ModuleContext ctx) {
        return this.isEnabled.apply((Object)ctx);
    }
}

