/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.plugin.linkaggregator;

import com.atlassian.greenhopper.api.entity.remotelink.sprint.RemoteSprintLink;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.RemoteSprintLinkService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.linkaggregation.AbstractRemoteLinkAggregator;
import com.atlassian.linkaggregation.JacksonJsonable;
import com.atlassian.linkaggregation.RemoteLinkAggregation;
import com.atlassian.linkaggregation.RemoteLinkAggregationJsonBean;
import com.atlassian.linkaggregation.RemoteLinkAggregationType;
import com.atlassian.linkaggregation.RemoteLinkAggregationTypeJsonBean;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.springframework.beans.factory.annotation.Autowired;

public class SprintRemoteLinkAggregator
extends AbstractRemoteLinkAggregator {
    private static final LoggerWrapper log = LoggerWrapper.with(SprintRemoteLinkAggregator.class);
    @Autowired
    private RemoteSprintLinkService remoteSprintLinkService;
    @Autowired
    private SprintManager sprintManager;

    public Iterable<RemoteLinkAggregation> aggregateForGlobalId(String globalId) {
        ServiceOutcome<List<RemoteSprintLink>> remoteLinkedSprintsOutcome = this.remoteSprintLinkService.getRemoteLinkedSprintsByGlobalId(globalId);
        if (remoteLinkedSprintsOutcome.isInvalid()) {
            log.error("Error loading remote links count. Reason: ", remoteLinkedSprintsOutcome.getErrors().toString());
            return this.transform(Collections.emptyList());
        }
        return this.transform(remoteLinkedSprintsOutcome.getValue());
    }

    private Iterable<RemoteLinkAggregation> transform(List<RemoteSprintLink> remoteSprintLinks) {
        long count = remoteSprintLinks.size();
        Iterable remoteSprintLinkJsonBeans = Iterables.transform(remoteSprintLinks, (Function)new Function<RemoteSprintLink, RemoteSprintLinkJsonBean>(){

            public RemoteSprintLinkJsonBean apply(@Nullable RemoteSprintLink remoteSprintLink) {
                ServiceOutcome<Sprint> sprintOutcome = SprintRemoteLinkAggregator.this.sprintManager.getSprint(remoteSprintLink.getSprintId());
                RemoteSprintLinkJsonBean remoteSprintLinkJsonBean = new RemoteSprintLinkJsonBean();
                remoteSprintLinkJsonBean.id = remoteSprintLink.getSprintId();
                if (sprintOutcome.isValid()) {
                    remoteSprintLinkJsonBean.name = sprintOutcome.getValue().getName();
                }
                return remoteSprintLinkJsonBean;
            }
        });
        RemoteLinkAggregationJsonBean aggregation = new RemoteLinkAggregationJsonBean((RemoteLinkAggregationType)new RemoteLinkAggregationTypeJsonBean("sprints"), Long.valueOf(count), remoteSprintLinkJsonBeans);
        return Collections.singletonList(aggregation);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private class RemoteSprintLinkJsonBean
    extends JacksonJsonable {
        @JsonProperty
        public Long id;
        @JsonProperty
        public String name;

        private RemoteSprintLinkJsonBean() {
        }
    }
}

