/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.plugin.linkaggregator;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.jira.exception.GetException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.linkaggregation.AbstractRemoteLinkAggregator;
import com.atlassian.linkaggregation.JacksonJsonable;
import com.atlassian.linkaggregation.RemoteLinkAggregation;
import com.atlassian.linkaggregation.RemoteLinkAggregationJsonBean;
import com.atlassian.linkaggregation.RemoteLinkAggregationType;
import com.atlassian.linkaggregation.RemoteLinkAggregationTypeJsonBean;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.springframework.beans.factory.annotation.Autowired;

public class EpicRemoteLinkAggregator
extends AbstractRemoteLinkAggregator {
    private final LoggerWrapper log = LoggerWrapper.with(EpicRemoteLinkAggregator.class);
    @Autowired
    private IssueManager issueManager;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private RemoteIssueLinkManager remoteIssueLinkManager;

    @Nonnull
    protected Iterable<RemoteLinkAggregation> aggregateForGlobalId(@Nonnull String globalId) {
        try {
            List remoteIssueLinks = this.remoteIssueLinkManager.findRemoteIssueLinksByGlobalIds(Collections.singletonList(globalId));
            return this.transform(this.filterEpics(remoteIssueLinks));
        }
        catch (GetException e) {
            this.log.warn("Problem occurred during aggregation of remote epic links", new Object[]{e});
            return Collections.emptyList();
        }
    }

    private Iterable<RemoteLinkAggregation> transform(Iterable<RemoteIssueLink> remoteIssueLinks) {
        Iterable remoteEpicLinkJsonBeans = Iterables.transform(remoteIssueLinks, (Function)new Function<RemoteIssueLink, RemoteEpicLinkJsonBean>(){

            public RemoteEpicLinkJsonBean apply(@Nullable RemoteIssueLink remoteIssueLink) {
                RemoteEpicLinkJsonBean remoteEpicLinkJsonBean = new RemoteEpicLinkJsonBean();
                return remoteEpicLinkJsonBean;
            }
        });
        long count = Lists.newArrayList((Iterable)remoteEpicLinkJsonBeans).size();
        RemoteLinkAggregationJsonBean aggregation = new RemoteLinkAggregationJsonBean((RemoteLinkAggregationType)new RemoteLinkAggregationTypeJsonBean("epics"), Long.valueOf(count), remoteEpicLinkJsonBeans);
        return Collections.singletonList(aggregation);
    }

    private Iterable<RemoteIssueLink> filterEpics(Iterable<RemoteIssueLink> remoteIssueLinks) {
        return Iterables.filter(remoteIssueLinks, (Predicate)new Predicate<RemoteIssueLink>(){

            public boolean apply(@Nullable RemoteIssueLink input) {
                MutableIssue issue = EpicRemoteLinkAggregator.this.issueManager.getIssueObject(input.getIssueId());
                return EpicRemoteLinkAggregator.this.issueIsEpic((Issue)issue);
            }
        });
    }

    private boolean issueIsEpic(Issue epic) {
        IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        return epicIssueType.equals(epic.getIssueTypeObject());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private class RemoteEpicLinkJsonBean
    extends JacksonJsonable {
        @JsonProperty
        public Long id;
        @JsonProperty
        public String name;

        private RemoteEpicLinkJsonBean() {
        }
    }
}

