/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.util.VersionStringComparator;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DevStatusPluginMetadataService {
    static final String DEV_STATUS_MIN_VERSION_RELEASE_REPORT = "2.3.0-D20140902T085958";
    @VisibleForTesting
    static final String DEV_STATUS_PLUGIN_KEY = "com.atlassian.jira.plugins.jira-development-integration-plugin";
    @Autowired
    private PluginAccessor pluginAccessor;
    private VersionStringComparator versionStringComparator = new VersionStringComparator();

    public boolean isReleaseReportSupported() {
        String devStatusVersion = null;
        Option<Plugin> plugin = this.getDevStatusPlugin();
        if (!plugin.isEmpty()) {
            devStatusVersion = ((Plugin)plugin.get()).getPluginInformation().getVersion();
        }
        return StringUtils.isNotEmpty(devStatusVersion) && this.versionStringComparator.compare(devStatusVersion, DEV_STATUS_MIN_VERSION_RELEASE_REPORT) >= 0;
    }

    private Option<Plugin> getDevStatusPlugin() {
        Plugin plugin = this.pluginAccessor.getPlugin(DEV_STATUS_PLUGIN_KEY);
        return Option.option((Object)plugin);
    }
}

