/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.validation;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugins.rest.common.validation.ValidationError;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement
public class JiraCopiedRestErrorCollection {
    @XmlElement
    private ArrayList<String> errorMessages = Lists.newArrayList();
    @XmlElement
    private HashMap<String, String> errors = Maps.newHashMap();

    public static Builder builder() {
        return Builder.newBuilder();
    }

    public static JiraCopiedRestErrorCollection of(String ... messages) {
        return JiraCopiedRestErrorCollection.of(Arrays.asList(messages));
    }

    public static JiraCopiedRestErrorCollection of(Iterable<String> messages) {
        Builder b = JiraCopiedRestErrorCollection.builder();
        for (String message : messages) {
            b.addErrorMessage(message);
        }
        return b.build();
    }

    public static JiraCopiedRestErrorCollection of(ErrorCollection errorCollection) {
        return JiraCopiedRestErrorCollection.builder().addErrorCollection(errorCollection).build();
    }

    private JiraCopiedRestErrorCollection() {
    }

    private JiraCopiedRestErrorCollection(Collection<String> errorMessages) {
        this.errorMessages.addAll((Collection)Assertions.notNull((String)"errorMessages", errorMessages));
    }

    private void addErrorCollection(ErrorCollection errorCollection) {
        this.errorMessages.addAll(((ErrorCollection)Assertions.notNull((String)"errorCollection", (Object)errorCollection)).getErrorMessages());
        this.errors.putAll(errorCollection.getErrors());
    }

    private void addErrorMessage(String errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    public boolean hasAnyErrors() {
        return !this.errorMessages.isEmpty() && !this.errors.isEmpty();
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class Builder {
        private JiraCopiedRestErrorCollection errorCollection;

        public static Builder newBuilder() {
            return new Builder(Collections.emptyList());
        }

        public static Builder newBuilder(ValidationError ... errors) {
            Assertions.notNull((String)"errors", (Object)errors);
            return new Builder(Collections.emptyList());
        }

        public static Builder newBuilder(Set<String> errorMessages) {
            Assertions.notNull((String)"errorMessages", errorMessages);
            return new Builder(errorMessages);
        }

        public static Builder newBuilder(Collection<ValidationError> errors) {
            Assertions.notNull((String)"errors", errors);
            return new Builder(Collections.emptyList());
        }

        public static Builder newBuilder(ErrorCollection errorCollection) {
            Assertions.notNull((String)"errorCollection", (Object)errorCollection);
            return new Builder(errorCollection.getErrorMessages());
        }

        Builder(Collection<String> errorMessages) {
            this.errorCollection = new JiraCopiedRestErrorCollection(errorMessages);
        }

        public Builder addErrorCollection(ErrorCollection errorCollection) {
            Assertions.notNull((String)"errorCollection", (Object)errorCollection);
            this.errorCollection.addErrorCollection(errorCollection);
            return this;
        }

        public Builder addErrorMessage(String errorMessage) {
            Assertions.notNull((String)"errorMessage", (Object)errorMessage);
            this.errorCollection.addErrorMessage(errorMessage);
            return this;
        }

        public JiraCopiedRestErrorCollection build() {
            return this.errorCollection;
        }
    }
}

