/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.validation;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.JiraCopiedBadRequestWebException;
import com.atlassian.greenhopper.model.validation.JiraCopiedConflictWebException;
import com.atlassian.greenhopper.model.validation.JiraCopiedNotAuthorisedWebException;
import com.atlassian.greenhopper.model.validation.JiraCopiedNotFoundWebException;
import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.greenhopper.model.validation.JiraCopiedServerErrorWebException;
import com.atlassian.jira.util.SimpleErrorCollection;

public class ErrorCollections {
    private static com.atlassian.jira.util.ErrorCollection toJiraErrorCollection(ErrorCollection errorCollection, I18n2 i18n) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        for (ErrorCollection.ErrorItem errorItem : errorCollection.getErrors()) {
            String message = i18n.getText(errorItem.getMessageKey(), errorItem.getParams());
            if (errorItem.getContextId() != null) {
                errors.addError(errorItem.getContextId(), message);
                continue;
            }
            errors.addErrorMessage(message);
        }
        return errors;
    }

    private static JiraCopiedRestErrorCollection toRestErrorCollection(ErrorCollection errorCollection, I18n2 i18n) {
        com.atlassian.jira.util.ErrorCollection errors = ErrorCollections.toJiraErrorCollection(errorCollection, i18n);
        return JiraCopiedRestErrorCollection.of(errors);
    }

    @Deprecated
    public static void checkErrors(ErrorCollection errorCollection, I18n2 i18n) {
        if (errorCollection.hasGlobalErrors() || errorCollection.hasErrors()) {
            JiraCopiedRestErrorCollection restErrorCollection = ErrorCollections.toRestErrorCollection(errorCollection, i18n);
            ErrorCollection.Reason definitiveReason = errorCollection.getDefinitiveReason();
            if (definitiveReason == null) {
                throw new JiraCopiedBadRequestWebException(restErrorCollection);
            }
            switch (definitiveReason) {
                case FORBIDDEN: {
                    throw new JiraCopiedNotAuthorisedWebException(restErrorCollection);
                }
                case NOT_FOUND: {
                    throw new JiraCopiedNotFoundWebException(restErrorCollection);
                }
                case SERVER_ERROR: {
                    throw new JiraCopiedServerErrorWebException(restErrorCollection);
                }
                case VALIDATION_FAILED: {
                    throw new JiraCopiedBadRequestWebException(restErrorCollection);
                }
                case CONFLICT: {
                    throw new JiraCopiedConflictWebException(restErrorCollection);
                }
            }
        }
    }
}

