/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.validation;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ErrorCollectionTransformerImpl
implements ErrorCollectionTransformer {
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    private static final Map<ErrorCollection.Reason, ErrorCollection.Reason> agileToJiraErrorReasonMap = ImmutableMap.builder().put((Object)ErrorCollection.Reason.CONFLICT, (Object)ErrorCollection.Reason.SERVER_ERROR).put((Object)ErrorCollection.Reason.FORBIDDEN, (Object)ErrorCollection.Reason.FORBIDDEN).put((Object)ErrorCollection.Reason.NOT_FOUND, (Object)ErrorCollection.Reason.NOT_FOUND).put((Object)ErrorCollection.Reason.SERVER_ERROR, (Object)ErrorCollection.Reason.SERVER_ERROR).put((Object)ErrorCollection.Reason.VALIDATION_FAILED, (Object)ErrorCollection.Reason.VALIDATION_FAILED).build();

    @Override
    public com.atlassian.jira.util.ErrorCollection toJiraErrorCollection(ErrorCollection errorCollection, ApplicationUser user) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        for (ErrorCollection.ErrorItem errorItem : errorCollection.getErrors()) {
            String message = this.i18nFactoryService.getI18n(user).getText(errorItem.getMessageKey(), errorItem.getParams());
            if (errorItem.getContextId() != null) {
                errors.addError(errorItem.getContextId(), message);
                continue;
            }
            errors.addErrorMessage(message);
        }
        ImmutableSet reasons = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(errorCollection.getReasons(), (Function)new Function<ErrorCollection.Reason, ErrorCollection.Reason>(){

            @Nullable
            public ErrorCollection.Reason apply(ErrorCollection.Reason reason) {
                return (ErrorCollection.Reason)agileToJiraErrorReasonMap.get((Object)reason);
            }
        }), (Predicate)Predicates.notNull()));
        errors.addReasons((Set)reasons);
        return errors;
    }

    @Override
    public com.atlassian.jira.util.ErrorCollection toJiraErrorCollection(ErrorCollection errorCollection) {
        return this.toJiraErrorCollection(errorCollection, this.jiraAuthenticationContext.getUser());
    }
}

