/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.rapid.AbstractModel;
import com.atlassian.greenhopper.model.rapid.NonWorkingDay;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.LocalDate;

public class WorkingDaysConfig
extends AbstractModel {
    private boolean monday;
    private boolean tuesday;
    private boolean wednesday;
    private boolean thursday;
    private boolean friday;
    private boolean saturday;
    private boolean sunday;
    private String timezoneId;
    private Set<NonWorkingDay> nonWorkingDays;

    private WorkingDaysConfig(Long id, boolean monday, boolean tuesday, boolean wednesday, boolean thursday, boolean friday, boolean saturday, boolean sunday, String timezoneId, Set<NonWorkingDay> nonWorkingDays) {
        super(id);
        this.monday = monday;
        this.tuesday = tuesday;
        this.wednesday = wednesday;
        this.thursday = thursday;
        this.friday = friday;
        this.saturday = saturday;
        this.sunday = sunday;
        this.timezoneId = timezoneId;
        this.nonWorkingDays = Collections.unmodifiableSet(nonWorkingDays);
    }

    public boolean isMonday() {
        return this.monday;
    }

    public boolean isTuesday() {
        return this.tuesday;
    }

    public boolean isWednesday() {
        return this.wednesday;
    }

    public boolean isThursday() {
        return this.thursday;
    }

    public boolean isFriday() {
        return this.friday;
    }

    public boolean isSaturday() {
        return this.saturday;
    }

    public boolean isSunday() {
        return this.sunday;
    }

    public String getTimezoneId() {
        return this.timezoneId;
    }

    public Set<NonWorkingDay> getNonWorkingDays() {
        return this.nonWorkingDays;
    }

    public Set<LocalDate> getNonWorkingLocalDates() {
        HashSet<LocalDate> localDates = new HashSet<LocalDate>();
        for (NonWorkingDay day : this.getNonWorkingDays()) {
            localDates.add(day.getLocalDate());
        }
        return localDates;
    }

    public boolean containsNonWorkingDay(LocalDate date) {
        for (NonWorkingDay day : this.getNonWorkingDays()) {
            if (!day.getLocalDate().equals((Object)date)) continue;
            return true;
        }
        return false;
    }

    public static WorkingDaysConfigBuilder builder() {
        return new WorkingDaysConfigBuilder();
    }

    public static WorkingDaysConfigBuilder builder(WorkingDaysConfig config) {
        return new WorkingDaysConfigBuilder(config);
    }

    public static class WorkingDaysConfigBuilder {
        private Long id;
        private boolean monday;
        private boolean tuesday;
        private boolean wednesday;
        private boolean thursday;
        private boolean friday;
        private boolean saturday;
        private boolean sunday;
        private String timezoneId;
        private Set<NonWorkingDay> nonWorkingDays = new HashSet<NonWorkingDay>();

        public WorkingDaysConfigBuilder() {
        }

        public WorkingDaysConfigBuilder(WorkingDaysConfig config) {
            this.id(config.getId()).monday(config.isMonday()).tuesday(config.isTuesday()).wednesday(config.isWednesday()).thursday(config.isThursday()).friday(config.isFriday()).saturday(config.isSaturday()).sunday(config.isSunday()).timezoneId(config.getTimezoneId()).nonWorkingDays(new HashSet<NonWorkingDay>(config.getNonWorkingDays()));
        }

        public WorkingDaysConfigBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public WorkingDaysConfigBuilder monday(boolean isWorkingDay) {
            this.monday = isWorkingDay;
            return this;
        }

        public WorkingDaysConfigBuilder tuesday(boolean isWorkingDay) {
            this.tuesday = isWorkingDay;
            return this;
        }

        public WorkingDaysConfigBuilder wednesday(boolean isWorkingDay) {
            this.wednesday = isWorkingDay;
            return this;
        }

        public WorkingDaysConfigBuilder thursday(boolean isWorkingDay) {
            this.thursday = isWorkingDay;
            return this;
        }

        public WorkingDaysConfigBuilder friday(boolean isWorkingDay) {
            this.friday = isWorkingDay;
            return this;
        }

        public WorkingDaysConfigBuilder saturday(boolean isWorkingDay) {
            this.saturday = isWorkingDay;
            return this;
        }

        public WorkingDaysConfigBuilder sunday(boolean isWorkingDay) {
            this.sunday = isWorkingDay;
            return this;
        }

        public WorkingDaysConfigBuilder timezoneId(String timezoneId) {
            this.timezoneId = timezoneId;
            return this;
        }

        public WorkingDaysConfigBuilder nonWorkingDays(Set<NonWorkingDay> nonWorkingDays) {
            this.nonWorkingDays = new HashSet<NonWorkingDay>(nonWorkingDays);
            return this;
        }

        public WorkingDaysConfigBuilder addNonWorkingDay(LocalDate date) {
            this.nonWorkingDays.add(NonWorkingDay.fromLocalDate(date));
            return this;
        }

        public WorkingDaysConfigBuilder removeNonWorkingDay(LocalDate date) {
            HashSet<NonWorkingDay> retained = new HashSet<NonWorkingDay>();
            for (NonWorkingDay day : this.nonWorkingDays) {
                if (day.getLocalDate().equals((Object)date)) continue;
                retained.add(day);
            }
            this.nonWorkingDays = retained;
            return this;
        }

        public WorkingDaysConfig build() {
            return new WorkingDaysConfig(this.id, this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday, this.sunday, this.timezoneId, this.nonWorkingDays);
        }
    }
}

