/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.rapid.AbstractModel;
import org.apache.commons.lang3.StringUtils;

public class Swimlane
extends AbstractModel {
    private final String name;
    private final String query;
    private final String description;
    private final boolean defaultLane;
    private final int position;

    private Swimlane(Long id, String name, String query, String description, boolean defaultLane, int position) {
        super(id);
        this.name = name;
        this.query = query;
        this.description = description;
        this.defaultLane = defaultLane;
        this.position = position;
    }

    public static SwimlaneBuilder builder() {
        return new SwimlaneBuilder();
    }

    public static SwimlaneBuilder builder(Swimlane swimlane) {
        return new SwimlaneBuilder(swimlane);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getQuery() {
        return this.query;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultLane() {
        return this.defaultLane;
    }

    public int getPosition() {
        return this.position;
    }

    public static class SwimlaneBuilder {
        private Long id;
        private String name;
        private String query;
        private String description;
        private boolean defaultLane;
        private int position;

        public SwimlaneBuilder() {
        }

        public SwimlaneBuilder(Swimlane swimlane) {
            this();
            this.id(swimlane.id).name(swimlane.name).query(swimlane.query).description(swimlane.description).defaultLane(swimlane.defaultLane);
        }

        public SwimlaneBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public SwimlaneBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SwimlaneBuilder query(String query) {
            this.query = query;
            return this;
        }

        public SwimlaneBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SwimlaneBuilder defaultLane(boolean defaultLane) {
            this.defaultLane = defaultLane;
            return this;
        }

        public SwimlaneBuilder position(int position) {
            this.position = position;
            return this;
        }

        public Swimlane build() {
            return new Swimlane(this.id, this.name, StringUtils.defaultString((String)this.query), StringUtils.defaultString((String)this.description), this.defaultLane, this.position);
        }
    }
}

