/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.jira.issue.fields.Field;

public class StatisticsFieldInstance
implements StatisticsField {
    private final StatisticsFieldConfig config;
    private final String nameKey;
    private final Field field;
    private final String documentId;

    public static StatisticsFieldInstance forNonField(StatisticsFieldConfig config, String nameKey) {
        return new StatisticsFieldInstance(config, nameKey);
    }

    public static StatisticsFieldInstance forJiraField(StatisticsFieldConfig config, Field field) {
        return new StatisticsFieldInstance(config, field);
    }

    public static StatisticsFieldInstance forJiraFieldWithName(StatisticsFieldConfig config, Field field, String nameKey) {
        return new StatisticsFieldInstance(config, field, nameKey);
    }

    public static StatisticsFieldInstance forJiraFieldWithNameWithDocumentId(StatisticsFieldConfig config, Field field, String nameKey, String documentId) {
        return new StatisticsFieldInstance(config, field, nameKey, documentId);
    }

    private StatisticsFieldInstance(StatisticsFieldConfig config, String nameKey) {
        this(config, null, nameKey, null);
    }

    private StatisticsFieldInstance(StatisticsFieldConfig config, Field field) {
        this(config, field, field.getNameKey());
    }

    private StatisticsFieldInstance(StatisticsFieldConfig config, Field field, String nameKey) {
        this(config, field, nameKey, field.getId());
    }

    private StatisticsFieldInstance(StatisticsFieldConfig config, Field field, String nameKey, String documentId) {
        this.config = config;
        this.field = field;
        this.nameKey = nameKey;
        this.documentId = documentId;
    }

    @Override
    public StatisticsFieldConfig getConfig() {
        return this.config;
    }

    @Override
    public String getDisplayName(I18n2 i18n) {
        return this.getName(i18n);
    }

    @Override
    public boolean isFieldBased() {
        return this.config.getType().isFieldBased();
    }

    public String getName(I18n2 i18n) {
        return i18n.getText(this.nameKey);
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.config.getType() != StatisticsFieldConfig.Type.NONE;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }
}

