/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.rapid.AbstractModel;

public class StatisticsFieldConfig
extends AbstractModel {
    private final Type type;
    private final String fieldId;

    private StatisticsFieldConfig(Long id, Type type, String fieldId) {
        super(id);
        this.type = type;
        this.fieldId = fieldId;
    }

    public Type getType() {
        return this.type;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public static StatisticsFieldConfigBuilder builder() {
        return new StatisticsFieldConfigBuilder();
    }

    public static StatisticsFieldConfig buildNone() {
        return StatisticsFieldConfig.builder().type(Type.NONE).build();
    }

    public static StatisticsFieldConfig buildIssueCount() {
        return StatisticsFieldConfig.builder().type(Type.ISSUE_COUNT).build();
    }

    public static StatisticsFieldConfig buildIssueCountExcludingSubs() {
        return StatisticsFieldConfig.builder().type(Type.ISSUE_COUNT_EXCL_SUBS).build();
    }

    public static class StatisticsFieldConfigBuilder {
        private Long id;
        private Type type;
        private String fieldId;

        public StatisticsFieldConfigBuilder() {
        }

        public StatisticsFieldConfigBuilder(StatisticsFieldConfig config) {
            this.id(config.getId()).fieldId(config.getFieldId()).type(config.getType());
        }

        public StatisticsFieldConfigBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public StatisticsFieldConfigBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public StatisticsFieldConfigBuilder type(String typeId) {
            this.type = Type.lookup(typeId);
            return this;
        }

        public StatisticsFieldConfigBuilder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public StatisticsFieldConfig build() {
            return new StatisticsFieldConfig(this.id, this.type, this.fieldId);
        }
    }

    public static enum Type {
        NONE("none", false),
        ISSUE_COUNT("issueCount", false),
        ISSUE_COUNT_EXCL_SUBS("issueCountExclSubs", false),
        JIRA_FIELD("field", true);

        private final String id;
        private final Boolean isFieldBased;

        private Type(String id, Boolean isFieldBased) {
            this.id = id;
            this.isFieldBased = isFieldBased;
        }

        public String getId() {
            return this.id;
        }

        public Boolean isFieldBased() {
            return this.isFieldBased;
        }

        public static Type lookup(String id) {
            for (Type t : Type.values()) {
                if (!t.getId().equals(id)) continue;
                return t;
            }
            return null;
        }
    }
}

