/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.model.rapid.ShowEpics;
import com.atlassian.greenhopper.model.rapid.SwimlaneStrategy;
import com.atlassian.jira.entity.WithId;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;

@ExperimentalApi
public class RapidView
implements WithId {
    private final Long id;
    private final String name;
    private final Long savedFilterId;
    private final String owner;
    private final boolean sprintSupportEnabled;
    private final boolean showDaysInColumn;
    private final SwimlaneStrategy swimlaneStrategy;
    private final CardColorStrategy cardColorStrategy;
    private final ShowEpics showEpicAsPanel;
    private final OldDoneIssuesCutoff oldDoneIssuesCutoff;
    private final boolean emptyFilterBoard;

    private RapidView(Long id, String name, Long savedFilterId, String owner, boolean sprintSupportEnabled, SwimlaneStrategy swimlaneStrategy, CardColorStrategy cardColorStrategy, boolean showDaysInColumn, ShowEpics showEpicAsPanel, OldDoneIssuesCutoff oldDoneIssuesCutoff, boolean emptyFilterBoard) {
        this.id = id;
        this.name = name;
        this.savedFilterId = savedFilterId;
        this.owner = owner;
        this.sprintSupportEnabled = sprintSupportEnabled;
        this.swimlaneStrategy = swimlaneStrategy;
        this.cardColorStrategy = cardColorStrategy;
        this.showDaysInColumn = showDaysInColumn;
        this.showEpicAsPanel = showEpicAsPanel;
        this.oldDoneIssuesCutoff = oldDoneIssuesCutoff;
        this.emptyFilterBoard = emptyFilterBoard;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getSavedFilterId() {
        return this.savedFilterId;
    }

    @Deprecated
    public String getOwner() {
        return this.owner;
    }

    public boolean isSprintSupportEnabled() {
        return this.sprintSupportEnabled;
    }

    public boolean showDaysInColumn() {
        return this.showDaysInColumn;
    }

    public SwimlaneStrategy getSwimlaneStrategy() {
        return this.swimlaneStrategy;
    }

    public CardColorStrategy getCardColorStrategy() {
        return this.cardColorStrategy;
    }

    public Type getType() {
        return this.isSprintSupportEnabled() ? Type.SCRUM : Type.KANBAN;
    }

    @ExperimentalApi
    public ShowEpics getShowEpicsAsPanel() {
        return this.showEpicAsPanel;
    }

    public OldDoneIssuesCutoff getOldDoneIssuesCutoff() {
        return this.oldDoneIssuesCutoff;
    }

    public boolean isOldDoneIssuesCutoffSpecified() {
        return !this.isSprintSupportEnabled() && this.oldDoneIssuesCutoff != OldDoneIssuesCutoff.NONE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RapidView other = (RapidView)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static RapidViewBuilder builder() {
        return new RapidViewBuilder();
    }

    public static RapidViewBuilder builder(RapidView rapidView) {
        return new RapidViewBuilder(rapidView);
    }

    public static class RapidViewBuilder {
        private Long id;
        private String name;
        private Long savedFilterId;
        private String owner;
        private boolean sprintSupportEnabled;
        private boolean showDaysInColumn;
        private SwimlaneStrategy swimlaneStrategy;
        private CardColorStrategy cardColorStrategy;
        private ShowEpics showEpicAsPanel;
        private OldDoneIssuesCutoff oldDoneIssuesCutoff;
        private boolean emptyFilterBoard;

        public RapidViewBuilder() {
        }

        public RapidViewBuilder(RapidView rapidView) {
            this();
            this.id(rapidView.id).name(rapidView.name).savedFilterId(rapidView.savedFilterId).owner(rapidView.owner).sprintSupportEnabled(rapidView.sprintSupportEnabled).swimlaneStrategy(rapidView.swimlaneStrategy).cardColorStrategy(rapidView.cardColorStrategy).showDaysInColumn(rapidView.showDaysInColumn).showEpicAsPanel(rapidView.showEpicAsPanel).oldDoneIssuesCutoff(rapidView.oldDoneIssuesCutoff).emptyFilterBoard(rapidView.emptyFilterBoard);
        }

        public RapidViewBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public RapidViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RapidViewBuilder savedFilterId(Long savedFilterId) {
            this.savedFilterId = savedFilterId;
            return this;
        }

        public RapidViewBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public RapidViewBuilder sprintSupportEnabled(boolean sprintSupportEnabled) {
            this.sprintSupportEnabled = sprintSupportEnabled;
            return this;
        }

        public RapidViewBuilder showDaysInColumn(boolean showDaysInColumn) {
            this.showDaysInColumn = showDaysInColumn;
            return this;
        }

        public RapidViewBuilder swimlaneStrategy(SwimlaneStrategy swimlaneStrategy) {
            this.swimlaneStrategy = swimlaneStrategy;
            return this;
        }

        public RapidViewBuilder cardColorStrategy(CardColorStrategy cardColorStrategy) {
            this.cardColorStrategy = cardColorStrategy;
            return this;
        }

        public RapidViewBuilder showEpicAsPanel(ShowEpics showEpicAsPanel) {
            this.showEpicAsPanel = showEpicAsPanel;
            return this;
        }

        public RapidViewBuilder oldDoneIssuesCutoff(OldDoneIssuesCutoff oldDoneIssuesCutoff) {
            this.oldDoneIssuesCutoff = oldDoneIssuesCutoff;
            return this;
        }

        public RapidViewBuilder emptyFilterBoard(boolean emptyFilterBoard) {
            this.emptyFilterBoard = emptyFilterBoard;
            return this;
        }

        public RapidView build() {
            return new RapidView(this.id, this.name, this.savedFilterId, this.owner, this.sprintSupportEnabled, this.swimlaneStrategy, this.cardColorStrategy, this.showDaysInColumn, this.showEpicAsPanel, this.oldDoneIssuesCutoff, this.emptyFilterBoard);
        }
    }

    public static enum OldDoneIssuesCutoff {
        ONE_WEEK("-1w"),
        TWO_WEEKS("-2w"),
        FOUR_WEEKS("-4w"),
        NONE("NONE");

        private String value;

        private OldDoneIssuesCutoff(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Optional<OldDoneIssuesCutoff> fromValue(String value) {
            return Stream.of(OldDoneIssuesCutoff.values()).filter(val -> val.getValue().equals(value)).findFirst();
        }
    }

    public static enum Type {
        SCRUM,
        KANBAN;

    }
}

