/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.rapid.AbstractModel;
import org.apache.commons.lang3.StringUtils;

public class QuickFilter
extends AbstractModel {
    private final String name;
    private final String query;
    private final String description;
    private final int position;

    private QuickFilter(Long id, String name, String query, String description, int position) {
        super(id);
        this.name = name;
        this.query = query;
        this.description = description;
        this.position = position;
    }

    public static QuickFilterBuilder builder() {
        return new QuickFilterBuilder();
    }

    public static QuickFilterBuilder builder(QuickFilter quickFilter) {
        return new QuickFilterBuilder(quickFilter);
    }

    public String getQuery() {
        return this.query;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPosition() {
        return this.position;
    }

    public static class QuickFilterBuilder {
        private Long id;
        private String name;
        private String query;
        private String description;
        private int position;

        public QuickFilterBuilder() {
        }

        public QuickFilterBuilder(QuickFilter quickFilter) {
            this.id(quickFilter.id).name(quickFilter.name).query(quickFilter.query).description(quickFilter.description);
        }

        public QuickFilterBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public QuickFilterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public QuickFilterBuilder query(String query) {
            this.query = query;
            return this;
        }

        public QuickFilterBuilder description(String description) {
            this.description = description;
            return this;
        }

        public QuickFilterBuilder position(int position) {
            this.position = position;
            return this;
        }

        public QuickFilter build() {
            return new QuickFilter(this.id, this.name, StringUtils.defaultString((String)this.query), StringUtils.defaultString((String)this.description), this.position);
        }
    }
}

