/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.rapid.AbstractModel;
import org.joda.time.LocalDate;

public class NonWorkingDay
extends AbstractModel {
    private String iso8601Date;

    private NonWorkingDay(Long id, String iso8601Date) {
        super(id);
        this.iso8601Date = iso8601Date;
    }

    public String getIso8601Date() {
        return this.iso8601Date;
    }

    public LocalDate getLocalDate() {
        return NonWorkingDay.fromISO8601(this.iso8601Date);
    }

    private static LocalDate fromISO8601(String dateString) {
        return LocalDate.parse((String)dateString);
    }

    private static String toISO8061(LocalDate date) {
        return date.toString();
    }

    public static NonWorkingDay fromISO8061String(String iso8601Date) {
        return NonWorkingDay.builder().iso8601Date(iso8601Date).build();
    }

    public static NonWorkingDay fromLocalDate(LocalDate localDate) {
        return NonWorkingDay.builder().iso8601Date(NonWorkingDay.toISO8061(localDate)).build();
    }

    public static NonWorkingDayBuilder builder() {
        return new NonWorkingDayBuilder();
    }

    public static NonWorkingDayBuilder builder(NonWorkingDay day) {
        return new NonWorkingDayBuilder(day);
    }

    public static class NonWorkingDayBuilder {
        private Long id;
        private String iso8601Date;

        public NonWorkingDayBuilder() {
        }

        public NonWorkingDayBuilder(NonWorkingDay day) {
            this.id(day.getId()).iso8601Date(day.getIso8601Date());
        }

        public NonWorkingDayBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public NonWorkingDayBuilder iso8601Date(String iso8601Date) {
            this.iso8601Date = iso8601Date;
            return this;
        }

        public NonWorkingDay build() {
            return new NonWorkingDay(this.id, this.iso8601Date);
        }
    }
}

