/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.service.workflow.PredefinedStatuses;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class KanbanBacklogColumn
extends Column {
    public static final String KANBAN_BACKLOG_NAME = PredefinedStatuses.BACKLOG.i18nNameKey;
    public static final String KANBAN_BACKLOG_SIGNATURE = "gh.kanplan.column@name=" + KANBAN_BACKLOG_NAME;

    private KanbanBacklogColumn(Long id, List<String> statusIds) {
        super(id, KANBAN_BACKLOG_SIGNATURE, null, null, statusIds);
    }

    @Override
    public String getName() {
        return KANBAN_BACKLOG_NAME;
    }

    public static boolean isKanbanBacklogColumn(Column column) {
        return column instanceof KanbanBacklogColumn || KanbanBacklogColumn.isKanbanBacklogColumnByName(column.getName());
    }

    public static boolean isKanbanBacklogColumnByName(String columnName) {
        return KANBAN_BACKLOG_SIGNATURE.equals(columnName);
    }

    public static KanbanBacklogColumn newKanbanBacklogColumn(Long columnId, List<String> statusIds) {
        return new KanbanBacklogColumn(columnId, statusIds);
    }

    public static KanbanBacklogColumn emptyKanbanBacklogColumn() {
        return new KanbanBacklogColumn(null, Lists.newArrayList());
    }

    public static KanbanBacklogColumn from(Column column) {
        return new KanbanBacklogColumn(column.getId(), column.getStatusIds());
    }

    public boolean isKanbanBacklogMapped() {
        return CollectionUtils.isNotEmpty(this.getStatusIds());
    }
}

