/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.rapid.AbstractModel;
import java.util.ArrayList;
import java.util.List;

public class Column
extends AbstractModel {
    private final String name;
    private final Double min;
    private final Double max;
    private final List<String> statusIds;

    protected Column(Long id, String name, Double min, Double max, List<String> statusIds) {
        super(id);
        this.name = name;
        this.min = min;
        this.max = max;
        this.statusIds = statusIds;
    }

    public static ColumnBuilder builder() {
        return new ColumnBuilder();
    }

    public static ColumnBuilder builder(Column column) {
        return new ColumnBuilder(column);
    }

    public String getName() {
        return this.name;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public List<String> getStatusIds() {
        return this.statusIds;
    }

    public static class ColumnBuilder {
        private Long id;
        private String name;
        private Double min;
        private Double max;
        private List<String> statusIds;

        public ColumnBuilder() {
            this.statusIds = new ArrayList<String>();
        }

        public ColumnBuilder(Column column) {
            this.name(column.name).id(column.id).min(column.min).max(column.max).statusIds(column.statusIds);
        }

        public ColumnBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ColumnBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ColumnBuilder min(Double min) {
            this.min = min;
            return this;
        }

        public ColumnBuilder max(Double max) {
            this.max = max;
            return this;
        }

        public ColumnBuilder statusIds(List<String> statusIds) {
            this.statusIds = statusIds;
            return this;
        }

        public ColumnBuilder statusId(String statusId) {
            this.statusIds.add(statusId);
            return this;
        }

        public Column build() {
            return new Column(this.id, this.name, this.min, this.max, this.statusIds);
        }
    }
}

