/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.rapid.AbstractModel;
import java.util.HashMap;
import java.util.Map;

public class CardLayoutField
extends AbstractModel {
    private final String fieldId;
    private final int position;
    private final Mode mode;

    public static CardLayoutFieldBuilder builder() {
        return new CardLayoutFieldBuilder();
    }

    public static CardLayoutFieldBuilder builder(CardLayoutField source) {
        return new CardLayoutFieldBuilder(source);
    }

    private CardLayoutField(Long id, int position, String fieldId, Mode mode) {
        super(id);
        this.position = position;
        this.fieldId = fieldId;
        this.mode = mode;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public int getPosition() {
        return this.position;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static class CardLayoutFieldBuilder {
        private Long id;
        private String fieldId;
        private int position;
        private Mode mode;

        public CardLayoutFieldBuilder() {
        }

        CardLayoutFieldBuilder(CardLayoutField source) {
            this.id = source.id;
            this.fieldId = source.fieldId;
            this.position = source.position;
            this.mode = source.mode;
        }

        public CardLayoutFieldBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public CardLayoutFieldBuilder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public CardLayoutFieldBuilder position(int position) {
            this.position = position;
            return this;
        }

        public CardLayoutFieldBuilder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public CardLayoutFieldBuilder withNewId() {
            this.id = null;
            return this;
        }

        public CardLayoutField build() {
            return new CardLayoutField(this.id, this.position, this.fieldId, this.mode);
        }
    }

    public static enum Mode {
        PLAN("planMode"),
        WORK("workMode");

        private static final Map<String, Mode> modeNameToModeMap;
        private final String modeName;

        private Mode(String modeName) {
            this.modeName = modeName;
        }

        public String getModeName() {
            return this.modeName;
        }

        public static Mode fromModeName(String modeName) {
            return modeNameToModeMap.get(modeName);
        }

        static {
            modeNameToModeMap = new HashMap<String, Mode>();
            for (Mode mode : Mode.values()) {
                modeNameToModeMap.put(mode.getModeName(), mode);
            }
        }
    }
}

