/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.rapid.AbstractModel;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import java.awt.Color;

public class CardColor
extends AbstractModel {
    private final CardColorStrategy strategy;
    private final Color color;
    private final String value;
    private final int position;

    private CardColor(Long id, CardColorStrategy strategy, Color color, String value, int position) {
        super(id);
        this.strategy = strategy;
        this.color = color;
        this.value = value;
        this.position = position;
    }

    public static CardColorBuilder builder() {
        return new CardColorBuilder();
    }

    public static CardColorBuilder builder(CardColor cardColor) {
        return new CardColorBuilder(cardColor);
    }

    public CardColorStrategy getStrategy() {
        return this.strategy;
    }

    public Color getColor() {
        return this.color;
    }

    public String getValue() {
        return this.value;
    }

    public int getPosition() {
        return this.position;
    }

    public static class CardColorBuilder {
        private Long id;
        private CardColorStrategy strategy;
        private Color color;
        private String value;
        private int position;

        public CardColorBuilder() {
        }

        public CardColorBuilder(CardColor cardColor) {
            this();
            this.id(cardColor.id).strategy(cardColor.strategy).color(cardColor.color).value(cardColor.value);
        }

        public CardColorBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public CardColorBuilder strategy(CardColorStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public CardColorBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public CardColorBuilder value(String value) {
            this.value = value;
            return this;
        }

        public CardColorBuilder position(int position) {
            this.position = position;
            return this;
        }

        public CardColor build() {
            return new CardColor(this.id, this.strategy, this.color, this.value, this.position);
        }
    }
}

