/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.rapid;

import com.atlassian.greenhopper.model.rapid.AbstractModel;
import org.joda.time.DateTime;

public class AuditEntry
extends AbstractModel {
    private final String user;
    private final DateTime time;
    private final Long entityId;
    private final String entityType;
    private final String category;
    private final String data;

    private AuditEntry(Long id, String user, DateTime time, Long entityId, String entityType, String category, String data) {
        super(id);
        this.user = user;
        this.time = time;
        this.entityId = entityId;
        this.entityType = entityType;
        this.category = category;
        this.data = data;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getUser() {
        return this.user;
    }

    public DateTime getTime() {
        return this.time;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getCategory() {
        return this.category;
    }

    public String getData() {
        return this.data;
    }

    public AuditEntryBuilder editBuilder() {
        return AuditEntry.builder(this);
    }

    public static AuditEntryBuilder builder() {
        return new AuditEntryBuilder();
    }

    public static AuditEntryBuilder builder(AuditEntry entry) {
        return new AuditEntryBuilder(entry);
    }

    public static class AuditEntryBuilder {
        private Long id;
        private String user;
        private DateTime time;
        private Long entityId;
        private String entityType;
        private String category;
        private String data;

        public AuditEntryBuilder() {
        }

        public AuditEntryBuilder(AuditEntry entry) {
            this.id = entry.id;
            this.user = entry.user;
            this.time = entry.time;
            this.entityId = entry.entityId;
            this.entityType = entry.entityType;
            this.category = entry.category;
            this.data = entry.data;
        }

        public Long getId() {
            return this.id;
        }

        public AuditEntryBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public String getUser() {
            return this.user;
        }

        public AuditEntryBuilder user(String user) {
            this.user = user;
            return this;
        }

        public DateTime getTime() {
            return this.time;
        }

        public AuditEntryBuilder time(DateTime time) {
            this.time = time;
            return this;
        }

        public Long getEntityId() {
            return this.entityId;
        }

        public AuditEntryBuilder entityId(Long entityId) {
            this.entityId = entityId;
            return this;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public AuditEntryBuilder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public String getCategory() {
            return this.category;
        }

        public AuditEntryBuilder category(String category) {
            this.category = category;
            return this;
        }

        public String getData() {
            return this.data;
        }

        public AuditEntryBuilder data(String data) {
            this.data = data;
            return this;
        }

        public AuditEntry build() {
            return new AuditEntry(this.id, this.user, this.time, this.entityId, this.entityType, this.category, this.data);
        }
    }
}

