/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.query;

import com.atlassian.greenhopper.service.rapid.EmptyQueryAwareJqlBuilder;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.query.clause.Clause;
import javax.annotation.Nonnull;

public class ClauseToAdd {
    private final Clause clause;
    private final boolean hasClause;

    public static ClauseToAdd clauseToAdd(Clause clause) {
        if (clause != null) {
            return new ClauseToAdd(clause);
        }
        return new ClauseToAdd();
    }

    public static ClauseToAdd noClauseToAdd() {
        return new ClauseToAdd();
    }

    public ClauseToAdd() {
        this.hasClause = false;
        this.clause = null;
    }

    public ClauseToAdd(@Nonnull Clause clause) {
        this.clause = (Clause)Assertions.notNull((String)"clause", (Object)clause);
        this.hasClause = true;
    }

    public Clause getClause() {
        return this.clause;
    }

    public boolean hasClause() {
        return this.hasClause;
    }

    public JqlQueryBuilder appendWithDefaultAnd(JqlQueryBuilder jqlQueryBuilder) {
        if (!this.hasClause) {
            return jqlQueryBuilder;
        }
        return jqlQueryBuilder.where().defaultAnd().addClause(this.clause).endWhere();
    }

    public JqlQueryBuilder appendWithDefaultOr(JqlQueryBuilder jqlQueryBuilder) {
        if (!this.hasClause) {
            return jqlQueryBuilder;
        }
        return jqlQueryBuilder.where().defaultOr().addClause(this.clause).endWhere();
    }

    public JqlQueryBuilder append(JqlQueryBuilder jqlQueryBuilder) {
        if (!this.hasClause) {
            return jqlQueryBuilder;
        }
        return jqlQueryBuilder.where().addClause(this.clause).endWhere();
    }

    public EmptyQueryAwareJqlBuilder append(EmptyQueryAwareJqlBuilder jqlQueryBuilder) {
        if (this.hasClause) {
            jqlQueryBuilder.where().addClause(this.clause).endWhere();
        }
        return jqlQueryBuilder;
    }

    public JqlClauseBuilder append(JqlClauseBuilder jqlClauseBuilder) {
        if (!this.hasClause) {
            return jqlClauseBuilder;
        }
        return jqlClauseBuilder.addClause(this.clause);
    }

    public EmptyQueryAwareJqlBuilder appendWithDefaultAnd(EmptyQueryAwareJqlBuilder jqlQueryBuilder) {
        if (this.hasClause) {
            jqlQueryBuilder.where().defaultAnd().addClause(this.clause).endWhere();
        }
        return jqlQueryBuilder;
    }
}

