/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.lexorank;

import com.atlassian.greenhopper.model.lexorank.LexoInteger;
import com.atlassian.greenhopper.model.lexorank.LexoRank;

public enum LexoRankBucket {
    BUCKET_0("0"),
    BUCKET_1("1"),
    BUCKET_2("2");

    private final LexoInteger value;

    private LexoRankBucket(String val) {
        this.value = LexoInteger.parse(val, LexoRank.NUMERAL_SYSTEM);
    }

    public static LexoRankBucket resolve(int bucketId) {
        for (LexoRankBucket bucket : LexoRankBucket.values()) {
            if (!bucket.value.equals(String.valueOf(bucketId))) continue;
            return bucket;
        }
        throw new IllegalArgumentException("No bucket found with id " + bucketId);
    }

    public String format() {
        return this.value.format();
    }

    public LexoRankBucket next() {
        switch (this) {
            case BUCKET_0: {
                return BUCKET_1;
            }
            case BUCKET_1: {
                return BUCKET_2;
            }
            case BUCKET_2: {
                return BUCKET_0;
            }
        }
        throw new RuntimeException("Unknown bucket: " + this.format());
    }

    public LexoRankBucket prev() {
        switch (this) {
            case BUCKET_0: {
                return BUCKET_2;
            }
            case BUCKET_1: {
                return BUCKET_0;
            }
            case BUCKET_2: {
                return BUCKET_1;
            }
        }
        throw new RuntimeException("Unknown bucket: " + this.format());
    }

    public static LexoRankBucket fromRank(String rank) {
        String bucket = rank.substring(0, rank.indexOf("|"));
        return LexoRankBucket.from(bucket);
    }

    public static LexoRankBucket from(String str) {
        LexoInteger val = LexoInteger.parse(str, LexoRank.NUMERAL_SYSTEM);
        for (LexoRankBucket bucket : LexoRankBucket.values()) {
            if (!bucket.value.equals(val)) continue;
            return bucket;
        }
        throw new RuntimeException("Unknown bucket: " + str);
    }

    public static LexoRankBucket max() {
        LexoRankBucket[] values = LexoRankBucket.values();
        return values[values.length - 1];
    }

    public Integer intValue() {
        switch (this) {
            case BUCKET_0: {
                return 0;
            }
            case BUCKET_1: {
                return 1;
            }
            case BUCKET_2: {
                return 2;
            }
        }
        throw new IllegalStateException(String.format("Illegal Lexo rank value %s", new Object[]{this}));
    }
}

