/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.lexorank;

import com.atlassian.greenhopper.model.lexorank.LexoDecimal;
import com.atlassian.greenhopper.model.lexorank.LexoInteger;
import com.atlassian.greenhopper.model.lexorank.LexoNumeralSystem;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;

public class LexoNumeralSystemHelper {
    private static final List<LexoInteger> BASE_36_DIVIDERS = ImmutableList.builder().add((Object)LexoInteger.make(LexoNumeralSystem.BASE_36, 1, new int[]{18})).add((Object)LexoInteger.make(LexoNumeralSystem.BASE_36, 1, new int[]{12})).add((Object)LexoInteger.make(LexoNumeralSystem.BASE_36, 1, new int[]{9})).add((Object)LexoInteger.make(LexoNumeralSystem.BASE_36, 1, new int[]{6})).add((Object)LexoInteger.make(LexoNumeralSystem.BASE_36, 1, new int[]{4})).add((Object)LexoInteger.make(LexoNumeralSystem.BASE_36, 1, new int[]{3})).add((Object)LexoInteger.make(LexoNumeralSystem.BASE_36, 1, new int[]{2})).add((Object)LexoInteger.make(LexoNumeralSystem.BASE_36, 1, new int[]{1})).build();

    public static List<LexoDecimal> getBaseDivisors(LexoNumeralSystem lexoNumeralSystem, int fractionMagnitude) {
        int base = lexoNumeralSystem.getBase();
        if (base == LexoNumeralSystem.BASE_36.getBase()) {
            if (fractionMagnitude < 0) {
                return BASE_36_DIVIDERS.stream().map(lexoInteger -> LexoDecimal.make(lexoInteger.shiftLeft(fractionMagnitude * -1), 0)).collect(Collectors.toList());
            }
            return BASE_36_DIVIDERS.stream().map(lexoInteger -> LexoDecimal.make(lexoInteger, fractionMagnitude)).collect(Collectors.toList());
        }
        throw new RuntimeException("Unsupported numeral system base: " + base);
    }
}

