/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.lexorank;

public interface LexoNumeralSystem {
    public static final LexoNumeralSystem BASE_10 = new LexoNumeralSystem(){

        @Override
        public int getBase() {
            return 10;
        }

        @Override
        public char getPositiveChar() {
            return '+';
        }

        @Override
        public char getNegativeChar() {
            return '-';
        }

        @Override
        public char getRadixPointChar() {
            return '.';
        }

        @Override
        public int toDigit(char ch) {
            if (ch >= '0' && ch <= '9') {
                return ch - 48;
            }
            throw new IllegalArgumentException("Not valid digit: " + ch);
        }

        @Override
        public char toChar(int digit) {
            return (char)(digit + 48);
        }
    };
    public static final LexoNumeralSystem BASE_36 = new LexoNumeralSystem(){
        private final char[] DIGITS = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();

        @Override
        public int getBase() {
            return 36;
        }

        @Override
        public char getPositiveChar() {
            return '+';
        }

        @Override
        public char getNegativeChar() {
            return '-';
        }

        @Override
        public char getRadixPointChar() {
            return ':';
        }

        @Override
        public int toDigit(char ch) {
            if (ch >= '0' && ch <= '9') {
                return ch - 48;
            }
            if (ch >= 'a' && ch <= 'z') {
                return ch - 97 + 10;
            }
            throw new IllegalArgumentException("Not valid digit: " + ch);
        }

        @Override
        public char toChar(int digit) {
            return this.DIGITS[digit];
        }
    };
    public static final LexoNumeralSystem BASE_64 = new LexoNumeralSystem(){
        private final char[] DIGITS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ^_abcdefghijklmnopqrstuvwxyz".toCharArray();

        @Override
        public int getBase() {
            return 64;
        }

        @Override
        public char getPositiveChar() {
            return '+';
        }

        @Override
        public char getNegativeChar() {
            return '-';
        }

        @Override
        public char getRadixPointChar() {
            return ':';
        }

        @Override
        public int toDigit(char ch) {
            if (ch >= '0' && ch <= '9') {
                return ch - 48;
            }
            if (ch >= 'A' && ch <= 'Z') {
                return ch - 65 + 10;
            }
            if (ch == '^') {
                return 36;
            }
            if (ch == '_') {
                return 37;
            }
            if (ch >= 'a' && ch <= 'z') {
                return ch - 97 + 38;
            }
            throw new IllegalArgumentException("Not valid digit: " + ch);
        }

        @Override
        public char toChar(int digit) {
            return this.DIGITS[digit];
        }
    };

    public int getBase();

    public char getPositiveChar();

    public char getNegativeChar();

    public char getRadixPointChar();

    public int toDigit(char var1);

    public char toChar(int var1);
}

