/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.lexorank;

import com.atlassian.greenhopper.model.lexorank.LexoNumeralSystem;
import java.util.Arrays;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class LexoInteger
implements Comparable<LexoInteger> {
    private static int[] ZERO_MAG = new int[]{0};
    private static int[] ONE_MAG = new int[]{1};
    public static final int NEGATIVE_SIGN = -1;
    public static final int ZERO_SIGN = 0;
    public static final int POSITIVE_SIGN = 1;
    private final LexoNumeralSystem sys;
    private final int sign;
    private final int[] mag;

    private LexoInteger(LexoNumeralSystem system, int sign, int[] mag) {
        this.sys = system;
        this.sign = sign;
        this.mag = mag;
    }

    public LexoInteger add(LexoInteger other) {
        this.checkSystem(other);
        if (this.isZero()) {
            return other;
        }
        if (other.isZero()) {
            return this;
        }
        if (this.sign != other.sign) {
            if (this.sign == -1) {
                LexoInteger pos = this.negate();
                LexoInteger val = pos.subtract(other);
                return val.negate();
            }
            LexoInteger pos = other.negate();
            return this.subtract(pos);
        }
        int[] result = LexoInteger.add(this.sys, this.mag, other.mag);
        return LexoInteger.make(this.sys, this.sign, result);
    }

    private static int[] add(LexoNumeralSystem sys, int[] l, int[] r) {
        int estimatedSize = Math.max(l.length, r.length);
        int[] result = new int[estimatedSize];
        int carry = 0;
        for (int i = 0; i < estimatedSize; ++i) {
            int lnum = i < l.length ? l[i] : 0;
            int rnum = i < r.length ? r[i] : 0;
            int sum = lnum + rnum + carry;
            carry = 0;
            while (sum >= sys.getBase()) {
                ++carry;
                sum -= sys.getBase();
            }
            result[i] = sum;
        }
        return LexoInteger.extendWithCarry(result, carry);
    }

    private static int[] extendWithCarry(int[] mag, int carry) {
        int[] result = mag;
        if (carry > 0) {
            int[] extendedMag = new int[result.length + 1];
            System.arraycopy(result, 0, extendedMag, 0, mag.length);
            extendedMag[extendedMag.length - 1] = carry;
            result = extendedMag;
        }
        return result;
    }

    public LexoInteger subtract(LexoInteger other) {
        this.checkSystem(other);
        if (this.isZero()) {
            return other.negate();
        }
        if (other.isZero()) {
            return this;
        }
        if (this.sign != other.sign) {
            if (this.sign == -1) {
                LexoInteger negate = this.negate();
                LexoInteger sum = negate.add(other);
                return sum.negate();
            }
            LexoInteger negate = other.negate();
            return this.add(negate);
        }
        int cmp = LexoInteger.compare(this.mag, other.mag);
        if (cmp == 0) {
            return LexoInteger.zero(this.sys);
        }
        if (cmp < 0) {
            return LexoInteger.make(this.sys, this.sign == -1 ? 1 : -1, LexoInteger.subtract(this.sys, other.mag, this.mag));
        }
        return LexoInteger.make(this.sys, this.sign == -1 ? -1 : 1, LexoInteger.subtract(this.sys, this.mag, other.mag));
    }

    private static int[] subtract(LexoNumeralSystem sys, int[] l, int[] r) {
        int[] rComplement = LexoInteger.complement(sys, r, l.length);
        int[] rSum = LexoInteger.add(sys, l, rComplement);
        rSum[rSum.length - 1] = 0;
        return LexoInteger.add(sys, rSum, ONE_MAG);
    }

    public LexoInteger multiply(LexoInteger other) {
        this.checkSystem(other);
        if (this.isZero()) {
            return this;
        }
        if (other.isZero()) {
            return other;
        }
        if (this.isOneish()) {
            if (this.sign == other.sign) {
                return LexoInteger.make(this.sys, 1, other.mag);
            }
            return LexoInteger.make(this.sys, -1, other.mag);
        }
        if (other.isOneish()) {
            if (this.sign == other.sign) {
                return LexoInteger.make(this.sys, 1, this.mag);
            }
            return LexoInteger.make(this.sys, -1, this.mag);
        }
        int[] newMag = LexoInteger.multiply(this.sys, this.mag, other.mag);
        if (this.sign == other.sign) {
            return LexoInteger.make(this.sys, 1, newMag);
        }
        return LexoInteger.make(this.sys, -1, newMag);
    }

    private static int[] multiply(LexoNumeralSystem sys, int[] l, int[] r) {
        int[] result = new int[l.length + r.length];
        for (int li = 0; li < l.length; ++li) {
            for (int ri = 0; ri < r.length; ++ri) {
                int resultIndex;
                int n = resultIndex = li + ri;
                result[n] = result[n] + l[li] * r[ri];
                while (result[resultIndex] >= sys.getBase()) {
                    int n2 = resultIndex + 1;
                    result[n2] = result[n2] + 1;
                    int n3 = resultIndex;
                    result[n3] = result[n3] - sys.getBase();
                }
            }
        }
        return result;
    }

    public LexoInteger negate() {
        if (this.isZero()) {
            return this;
        }
        return LexoInteger.make(this.sys, this.sign == 1 ? -1 : 1, this.mag);
    }

    public LexoInteger shiftLeft() {
        return this.shiftLeft(1);
    }

    public LexoInteger shiftLeft(int times) {
        if (times == 0) {
            return this;
        }
        if (times < 0) {
            return this.shiftRight(Math.abs(times));
        }
        int[] nmag = new int[this.mag.length + times];
        System.arraycopy(this.mag, 0, nmag, times, this.mag.length);
        return LexoInteger.make(this.sys, this.sign, nmag);
    }

    public LexoInteger shiftRight() {
        return this.shiftRight(1);
    }

    public LexoInteger shiftRight(int times) {
        if (times == 0) {
            return this;
        }
        if (times < 0) {
            return this.shiftLeft(Math.abs(times));
        }
        if (this.mag.length - times <= 0) {
            return LexoInteger.zero(this.sys);
        }
        int[] nmag = new int[this.mag.length - times];
        System.arraycopy(this.mag, times, nmag, 0, nmag.length);
        return LexoInteger.make(this.sys, this.sign, nmag);
    }

    public LexoInteger complement() {
        return this.complement(this.mag.length);
    }

    public LexoInteger complement(int digits) {
        return LexoInteger.make(this.sys, this.sign, LexoInteger.complement(this.sys, this.mag, digits));
    }

    private static int[] complement(LexoNumeralSystem sys, int[] mag, int digits) {
        if (digits <= 0) {
            throw new IllegalArgumentException("Expected at least 1 digit");
        }
        int[] nmag = new int[digits];
        Arrays.fill(nmag, sys.getBase() - 1);
        for (int i = 0; i < mag.length; ++i) {
            nmag[i] = sys.getBase() - 1 - mag[i];
        }
        return nmag;
    }

    public boolean isZero() {
        return this.sign == 0 && this.mag.length == 1 && this.mag[0] == 0;
    }

    private boolean isOneish() {
        return this.mag.length == 1 && this.mag[0] == 1;
    }

    public boolean isOne() {
        return this.sign == 1 && this.mag.length == 1 && this.mag[0] == 1;
    }

    int getMag(int index) {
        return this.mag[index];
    }

    int getMagSize() {
        return this.mag.length;
    }

    @Override
    public int compareTo(LexoInteger o) {
        if (this.sign == -1) {
            if (o.sign == -1) {
                int cmp = LexoInteger.compare(this.mag, o.mag);
                if (cmp == -1) {
                    return 1;
                }
                if (cmp == 1) {
                    return -1;
                }
                return 0;
            }
            return -1;
        }
        if (this.sign == 1) {
            if (o.sign == 1) {
                return LexoInteger.compare(this.mag, o.mag);
            }
            return 1;
        }
        if (o.sign == -1) {
            return 1;
        }
        if (o.sign == 1) {
            return -1;
        }
        return 0;
    }

    private static int compare(int[] l, int[] r) {
        if (l.length < r.length) {
            return -1;
        }
        if (l.length > r.length) {
            return 1;
        }
        for (int i = l.length - 1; i >= 0; --i) {
            if (l[i] < r[i]) {
                return -1;
            }
            if (l[i] <= r[i]) continue;
            return 1;
        }
        return 0;
    }

    public LexoNumeralSystem getSystem() {
        return this.sys;
    }

    private void checkSystem(LexoInteger other) {
        if (this.sys != other.sys) {
            throw new IllegalArgumentException("Expected numbers of same numeral sys");
        }
    }

    public String format() {
        if (this.isZero()) {
            return "" + this.sys.toChar(0);
        }
        StringBuilder sb = new StringBuilder();
        for (int digit : this.mag) {
            sb.insert(0, this.sys.toChar(digit));
        }
        if (this.sign == -1) {
            sb.insert(0, this.sys.getNegativeChar());
        }
        return sb.toString();
    }

    public static LexoInteger parse(String strFull, LexoNumeralSystem system) {
        String str = strFull;
        int sign = 1;
        if (str.indexOf(system.getPositiveChar()) == 0) {
            str = str.substring(1);
        } else if (str.indexOf(system.getNegativeChar()) == 0) {
            str = str.substring(1);
            sign = -1;
        }
        int[] mag = new int[str.length()];
        int strIndex = mag.length - 1;
        int magIndex = 0;
        while (strIndex >= 0) {
            mag[magIndex] = system.toDigit(str.charAt(strIndex));
            --strIndex;
            ++magIndex;
        }
        return LexoInteger.make(system, sign, mag);
    }

    protected static LexoInteger zero(LexoNumeralSystem sys) {
        return new LexoInteger(sys, 0, ZERO_MAG);
    }

    protected static LexoInteger one(LexoNumeralSystem sys) {
        return LexoInteger.make(sys, 1, ONE_MAG);
    }

    public static LexoInteger make(LexoNumeralSystem sys, int sign, int[] mag) {
        int actualLength;
        for (actualLength = mag.length; actualLength > 0 && mag[actualLength - 1] == 0; --actualLength) {
        }
        if (actualLength == 0) {
            return LexoInteger.zero(sys);
        }
        if (actualLength == mag.length) {
            return new LexoInteger(sys, sign, mag);
        }
        int[] nmag = new int[actualLength];
        System.arraycopy(mag, 0, nmag, 0, actualLength);
        return new LexoInteger(sys, sign, nmag);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LexoInteger)) {
            return false;
        }
        LexoInteger o = (LexoInteger)obj;
        return this.sys == o.sys && this.compareTo(o) == 0;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public String toString() {
        return this.format();
    }
}

