/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.lexorank;

import com.atlassian.greenhopper.model.lexorank.LexoInteger;
import com.atlassian.greenhopper.model.lexorank.LexoNumeralSystem;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class LexoDecimal
implements Comparable<LexoDecimal> {
    private final LexoInteger mag;
    private final int sig;

    private LexoDecimal(LexoInteger mag, int sig) {
        this.mag = mag;
        this.sig = sig;
    }

    public static LexoDecimal half(LexoNumeralSystem sys) {
        int mid = sys.getBase() / 2;
        return LexoDecimal.make(LexoInteger.make(sys, 1, new int[]{mid}), 1);
    }

    public static LexoDecimal parse(String str, LexoNumeralSystem system) {
        int partialIndex = str.indexOf(system.getRadixPointChar());
        if (str.lastIndexOf(system.getRadixPointChar()) != partialIndex) {
            throw new NumberFormatException("More than one " + system.getRadixPointChar());
        }
        if (partialIndex < 0) {
            return LexoDecimal.make(LexoInteger.parse(str, system), 0);
        }
        String intStr = str.substring(0, partialIndex) + str.substring(partialIndex + 1);
        return LexoDecimal.make(LexoInteger.parse(intStr, system), str.length() - 1 - partialIndex);
    }

    public static LexoDecimal from(LexoInteger integer) {
        return LexoDecimal.make(integer, 0);
    }

    public static LexoDecimal make(LexoInteger integer, int sig) {
        if (integer.isZero()) {
            return new LexoDecimal(integer, 0);
        }
        int zeroCount = 0;
        for (int i = 0; i < sig && integer.getMag(i) == 0; ++i) {
            ++zeroCount;
        }
        LexoInteger newInteger = integer.shiftRight(zeroCount);
        int newSig = sig - zeroCount;
        return new LexoDecimal(newInteger, newSig);
    }

    public static LexoDecimal fromInt(int value, LexoNumeralSystem system) {
        char decimalPoint = LexoNumeralSystem.BASE_10.getRadixPointChar();
        char targetSystemPoint = system.getRadixPointChar();
        String lexoString = Integer.toString(value, system.getBase()).replace(decimalPoint, targetSystemPoint);
        return LexoDecimal.parse(lexoString, system);
    }

    public LexoNumeralSystem getSystem() {
        return this.mag.getSystem();
    }

    public int getOrderOfMagnitude() {
        return this.mag.getMagSize() - this.sig - 1;
    }

    public LexoDecimal add(LexoDecimal other) {
        int tsig;
        LexoInteger tmag = this.mag;
        LexoInteger omag = other.mag;
        int osig = other.sig;
        for (tsig = this.sig; tsig < osig; ++tsig) {
            tmag = tmag.shiftLeft();
        }
        while (tsig > osig) {
            omag = omag.shiftLeft();
            ++osig;
        }
        return LexoDecimal.make(tmag.add(omag), tsig);
    }

    public LexoDecimal subtract(LexoDecimal other) {
        int thisSig;
        LexoInteger thisMag = this.mag;
        LexoInteger otherMag = other.mag;
        int otherSig = other.sig;
        for (thisSig = this.sig; thisSig < otherSig; ++thisSig) {
            thisMag = thisMag.shiftLeft();
        }
        while (thisSig > otherSig) {
            otherMag = otherMag.shiftLeft();
            ++otherSig;
        }
        return LexoDecimal.make(thisMag.subtract(otherMag), thisSig);
    }

    public LexoDecimal multiply(LexoDecimal other) {
        return LexoDecimal.make(this.mag.multiply(other.mag), this.sig + other.sig);
    }

    public LexoInteger floor() {
        return this.mag.shiftRight(this.sig);
    }

    public LexoInteger ceil() {
        if (this.isExact()) {
            return this.mag;
        }
        LexoInteger floor = this.floor();
        return floor.add(LexoInteger.one(floor.getSystem()));
    }

    public boolean isExact() {
        if (this.sig == 0) {
            return true;
        }
        for (int i = 0; i < this.sig; ++i) {
            if (this.mag.getMag(i) == 0) continue;
            return false;
        }
        return true;
    }

    public LexoInteger getMag() {
        return this.mag;
    }

    public int getScale() {
        return this.sig;
    }

    public LexoDecimal setScale(int nsig) {
        return this.setScale(nsig, false);
    }

    public LexoDecimal setScale(int nsig, boolean ceiling) {
        if (nsig >= this.sig) {
            return this;
        }
        if (nsig < 0) {
            nsig = 0;
        }
        int diff = this.sig - nsig;
        LexoInteger nmag = this.mag.shiftRight(diff);
        if (ceiling) {
            nmag = nmag.add(LexoInteger.one(nmag.getSystem()));
        }
        return LexoDecimal.make(nmag, nsig);
    }

    @Override
    public int compareTo(LexoDecimal o) {
        LexoInteger tMag = this.mag;
        LexoInteger oMag = o.mag;
        if (this.sig > o.sig) {
            oMag = oMag.shiftLeft(this.sig - o.sig);
        } else if (this.sig < o.sig) {
            tMag = tMag.shiftLeft(o.sig - this.sig);
        }
        return tMag.compareTo(oMag);
    }

    public String format() {
        boolean specialHead;
        String intStr = this.mag.format();
        if (this.sig == 0) {
            return intStr;
        }
        StringBuilder sb = new StringBuilder(intStr);
        char head = sb.charAt(0);
        boolean bl = specialHead = head == this.mag.getSystem().getPositiveChar() || head == this.mag.getSystem().getNegativeChar();
        if (specialHead) {
            sb.deleteCharAt(0);
        }
        while (sb.length() < this.sig + 1) {
            sb.insert(0, this.mag.getSystem().toChar(0));
        }
        sb.insert(sb.length() - this.sig, this.mag.getSystem().getRadixPointChar());
        if (sb.length() - this.sig == 0) {
            sb.insert(0, this.mag.getSystem().toChar(0));
        }
        if (specialHead) {
            sb.insert(0, head);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LexoDecimal)) {
            return false;
        }
        LexoDecimal o = (LexoDecimal)obj;
        return this.mag.equals(o.mag) && this.sig == o.sig;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public String toString() {
        return this.format();
    }
}

