/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.workingdays;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysAO;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysAOMapper;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysDao;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkingDaysManagerImpl
implements WorkingDaysManager {
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private WorkingDaysDao workingDaysDao;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    private WorkingDaysAOMapper workingDaysAOMapper;
    private Cache<Long, WorkingDaysConfig> workingDaysConfigCache;

    @PostConstruct
    public void init() {
        this.workingDaysConfigCache = this.cacheFactoryManager.create().getCache(WorkingDaysManagerImpl.class.getName() + ".workingDaysConfigCache", new WorkingDaysConfigCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    @Autowired
    @VisibleForTesting
    void setWorkingDaysAOMapper(WorkingDaysAOMapper workingDaysAOMapper) {
        this.workingDaysAOMapper = workingDaysAOMapper;
    }

    @Override
    public void flushCache() {
        this.workingDaysConfigCache.removeAll();
    }

    @Override
    public ServiceOutcome<WorkingDaysConfig> get(RapidView rapidView) {
        WorkingDaysConfig cachedConfig = this.workingDaysConfigCache.get(rapidView.getId());
        return ServiceOutcomeImpl.ok(cachedConfig);
    }

    @Override
    public ServiceOutcome<WorkingDaysConfig> update(RapidView rapidView, WorkingDaysConfig workingDaysConfig) {
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        WorkingDaysAO updated = this.workingDaysDao.updateOne((RapidViewAO)rapidViewAO.getValue(), workingDaysConfig);
        this.workingDaysConfigCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(this.workingDaysAOMapper.toModel(updated));
    }

    @Override
    public ServiceOutcome<WorkingDaysConfig> copy(RapidView sourceRapidView, RapidView targetRapidView) {
        ServiceOutcome<WorkingDaysConfig> workingDaysConfig = this.get(sourceRapidView);
        if (!workingDaysConfig.isValid()) {
            return ServiceOutcomeImpl.error(workingDaysConfig);
        }
        return this.update(targetRapidView, workingDaysConfig.getValue());
    }

    @Override
    public void delete(RapidViewAO rapidViewAO) {
        this.workingDaysConfigCache.remove(rapidViewAO.getId());
        this.workingDaysDao.deleteForParent(rapidViewAO);
    }

    private WorkingDaysConfig createDefault() {
        return WorkingDaysConfig.builder().monday(true).tuesday(true).wednesday(true).thursday(true).friday(true).saturday(true).sunday(true).timezoneId("defaultTimeZoneId").build();
    }

    private class WorkingDaysConfigCacheLoader
    implements CacheLoader<Long, WorkingDaysConfig> {
        private WorkingDaysConfigCacheLoader() {
        }

        @Override
        public WorkingDaysConfig load(@Nonnull Long rapidViewId) {
            WorkingDaysAO entity = WorkingDaysManagerImpl.this.workingDaysDao.getOne(rapidViewId);
            if (entity == null) {
                return WorkingDaysManagerImpl.this.createDefault();
            }
            return WorkingDaysManagerImpl.this.workingDaysAOMapper.toModel(entity);
        }
    }
}

