/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.workingdays;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.manager.workingdays.NonWorkingDayAOMapper;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysAO;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysAOListMapper;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysAOMapper;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.ObjectNotFoundException;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkingDaysDao
extends GenericActiveObjectsDao<Long, WorkingDaysAO>
implements RelatedEntityDao<Long, RapidViewAO, WorkingDaysAO, WorkingDaysConfig> {
    @Autowired
    private WorkingDaysAOMapper workingDaysAOMapper;
    @Autowired
    private NonWorkingDayAOMapper nonWorkingDayAOMapper;

    @Nonnull
    public WorkingDaysAO[] getForParent(RapidViewAO rapidViewAO) {
        return this.getForParent(rapidViewAO.getId());
    }

    public WorkingDaysAO[] getForParent(Long primaryKey) {
        return (WorkingDaysAO[])this.ao.find(WorkingDaysAO.class, "RAPID_VIEW_ID = ?", new Object[]{primaryKey});
    }

    public WorkingDaysAO getOne(Long rapidViewId) {
        WorkingDaysAO[] workingDaysAOs = this.getForParent(rapidViewId);
        if (workingDaysAOs.length == 0) {
            return null;
        }
        return workingDaysAOs[0];
    }

    @Override
    @Nonnull
    public List<WorkingDaysAO> updateForParent(RapidViewAO rapidViewAO, List<WorkingDaysConfig> models) {
        return AOUtil.setListValues(this.ao, new WorkingDaysAOListMapper(rapidViewAO, this.workingDaysAOMapper, this.ao, this.nonWorkingDayAOMapper), models);
    }

    @Nonnull
    public WorkingDaysAO updateOne(RapidViewAO rapidViewAO, WorkingDaysConfig workingDaysConfig) {
        List<WorkingDaysAO> workingDaysAOs = AOUtil.setListValues(this.ao, new WorkingDaysAOListMapper(rapidViewAO, this.workingDaysAOMapper, this.ao, this.nonWorkingDayAOMapper), Collections.singletonList(workingDaysConfig));
        if (workingDaysAOs.isEmpty()) {
            ObjectNotFoundException e = new ObjectNotFoundException(String.format("After updating working days config '%s' we are left with no WorkingDaysAOs records for rapid view id=%d", ToStringBuilder.reflectionToString((Object)workingDaysConfig), rapidViewAO.getId()));
            throw e;
        }
        return workingDaysAOs.get(0);
    }

    @Override
    public void deleteForParent(RapidViewAO rapidViewAO) {
        WorkingDaysAO[] workingDaysAOs = rapidViewAO.getWorkingDays();
        if (workingDaysAOs != null) {
            this.delete(workingDaysAOs);
        }
    }

    protected void preDelete(WorkingDaysAO ... entities) {
        for (WorkingDaysAO workingDaysAO : entities) {
            this.ao.delete((RawEntity[])workingDaysAO.getNonWorkingDays());
            this.ao.flush(new RawEntity[]{workingDaysAO});
        }
    }
}

