/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.workingdays;

import com.atlassian.greenhopper.manager.RelatedAOMapper;
import com.atlassian.greenhopper.manager.workingdays.NonWorkingDayAO;
import com.atlassian.greenhopper.manager.workingdays.NonWorkingDayAOMapper;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysAO;
import com.atlassian.greenhopper.model.rapid.NonWorkingDay;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkingDaysAOMapper
implements RelatedAOMapper<RapidViewAO, WorkingDaysAO, WorkingDaysConfig> {
    private NonWorkingDayAOMapper nonWorkingDayAOMapper;

    @Autowired
    @VisibleForTesting
    void setNonWorkingDayAOMapper(NonWorkingDayAOMapper nonWorkingDayAOMapper) {
        this.nonWorkingDayAOMapper = nonWorkingDayAOMapper;
    }

    @Override
    @Nonnull
    public Map<String, Object> toAO(WorkingDaysConfig workingDaysConfig) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MONDAY", workingDaysConfig.isMonday());
        map.put("TUESDAY", workingDaysConfig.isTuesday());
        map.put("WEDNESDAY", workingDaysConfig.isWednesday());
        map.put("THURSDAY", workingDaysConfig.isThursday());
        map.put("FRIDAY", workingDaysConfig.isFriday());
        map.put("SATURDAY", workingDaysConfig.isSaturday());
        map.put("SUNDAY", workingDaysConfig.isSunday());
        map.put("TIMEZONE", workingDaysConfig.getTimezoneId());
        return map;
    }

    @Override
    @Nonnull
    public Map<String, Object> toAO(RapidViewAO rapidViewAO, WorkingDaysConfig workingDaysConfig) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.toAO(workingDaysConfig));
        map.put("RAPID_VIEW_ID", rapidViewAO);
        return map;
    }

    @Override
    @Nonnull
    public WorkingDaysConfig toModel(WorkingDaysAO workingDaysAO) {
        HashSet<NonWorkingDay> nonWorkingDays = new HashSet<NonWorkingDay>();
        for (NonWorkingDayAO nonWorkingDayAO : workingDaysAO.getNonWorkingDays()) {
            nonWorkingDays.add(this.nonWorkingDayAOMapper.toModel(nonWorkingDayAO));
        }
        return WorkingDaysConfig.builder().id(workingDaysAO.getId()).monday(workingDaysAO.getMonday()).tuesday(workingDaysAO.getTuesday()).wednesday(workingDaysAO.getWednesday()).thursday(workingDaysAO.getThursday()).friday(workingDaysAO.getFriday()).saturday(workingDaysAO.getSaturday()).sunday(workingDaysAO.getSunday()).timezoneId(workingDaysAO.getTimezone()).nonWorkingDays(nonWorkingDays).build();
    }

    @Override
    public void update(WorkingDaysConfig source, WorkingDaysAO target) {
        target.setMonday(source.isMonday());
        target.setTuesday(source.isTuesday());
        target.setWednesday(source.isWednesday());
        target.setThursday(source.isThursday());
        target.setFriday(source.isFriday());
        target.setSaturday(source.isSaturday());
        target.setSunday(source.isSunday());
        target.setTimezone(source.getTimezoneId());
    }
}

