/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.workingdays;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.AbstractRelatedAOListMapper;
import com.atlassian.greenhopper.manager.workingdays.NonWorkingDayAOListMapper;
import com.atlassian.greenhopper.manager.workingdays.NonWorkingDayAOMapper;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysAO;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysAOMapper;
import com.atlassian.greenhopper.model.rapid.NonWorkingDay;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.ArrayList;
import net.java.ao.RawEntity;

public class WorkingDaysAOListMapper
extends AbstractRelatedAOListMapper<RapidViewAO, WorkingDaysAO, WorkingDaysConfig> {
    private final ActiveObjects ao;
    private NonWorkingDayAOMapper nonWorkingDayAOMapper;

    public WorkingDaysAOListMapper(RapidViewAO rapidViewAO, WorkingDaysAOMapper mapper, ActiveObjects ao, NonWorkingDayAOMapper nonWorkingDayAOMapper) {
        super(rapidViewAO, mapper);
        this.ao = ao;
        this.nonWorkingDayAOMapper = nonWorkingDayAOMapper;
    }

    @Override
    public Class<WorkingDaysAO> getActiveObjectClass() {
        return WorkingDaysAO.class;
    }

    @Override
    public void postCreateUpdate(WorkingDaysAO recordAO, WorkingDaysConfig workingDaysConfig) {
        AOUtil.setListValues(this.ao, new NonWorkingDayAOListMapper(recordAO, this.nonWorkingDayAOMapper), new ArrayList<NonWorkingDay>(workingDaysConfig.getNonWorkingDays()));
        this.ao.flush(new RawEntity[]{recordAO});
    }

    @Override
    public void preDelete(WorkingDaysAO workingDaysAO) {
        this.ao.delete((RawEntity[])workingDaysAO.getNonWorkingDays());
        this.ao.flush(new RawEntity[]{workingDaysAO});
    }

    public WorkingDaysAO[] getExisting() {
        return ((RapidViewAO)this.parentAO).getWorkingDays();
    }
}

