/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.version;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.manager.GreenHopperCache;
import com.atlassian.greenhopper.manager.version.VersionMetaDataAO;
import com.atlassian.greenhopper.manager.version.VersionMetaDataAOMapper;
import com.atlassian.greenhopper.manager.version.VersionMetaDataDao;
import com.atlassian.greenhopper.model.rapid.LegacyVersionMetaDataImpl;
import com.atlassian.greenhopper.project.version.VersionAdapter;
import com.atlassian.greenhopper.project.version.VersionMetaData;
import com.atlassian.jira.project.version.Version;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionMetaDataManagerImpl
implements VersionAdapter,
GreenHopperCache {
    @Autowired
    private VersionMetaDataDao versionMetaDataDao;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    private Cache<Long, VersionMetaData> versionMetaDataCache;
    private VersionMetaDataAOMapper versionMetaDataAOMapper;

    @PostConstruct
    public void init() {
        CacheSettings settings = new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(100000).build();
        this.versionMetaDataCache = this.cacheFactoryManager.create().getCache(VersionMetaDataManagerImpl.class.getName() + ".versionMetaDataCache", new VersionMetaDataCacheLoader(), settings);
    }

    @Autowired
    @VisibleForTesting
    void setVersionMetaDataAOMapper(VersionMetaDataAOMapper versionMetaDataAOMapper) {
        this.versionMetaDataAOMapper = versionMetaDataAOMapper;
    }

    @Override
    public void flushCache() {
        this.versionMetaDataCache.removeAll();
    }

    @Override
    public VersionMetaData get(Version version) {
        Long versionId = version.getId();
        VersionMetaData cachedVersion = this.versionMetaDataCache.get(versionId);
        return cachedVersion;
    }

    @Override
    public VersionMetaData update(VersionMetaData metaData) {
        VersionMetaDataAO ao = this.versionMetaDataDao.updateOne(LegacyVersionMetaDataImpl.builder(metaData).build());
        LegacyVersionMetaDataImpl versionMetaData = this.versionMetaDataAOMapper.toModel(ao);
        this.versionMetaDataCache.remove(versionMetaData.getVersionId());
        return versionMetaData;
    }

    private LegacyVersionMetaDataImpl createDefault(Long versionId) {
        return LegacyVersionMetaDataImpl.builder().versionId(versionId).build();
    }

    private class VersionMetaDataCacheLoader
    implements CacheLoader<Long, VersionMetaData> {
        private VersionMetaDataCacheLoader() {
        }

        @Override
        public VersionMetaData load(@Nonnull Long versionId) {
            VersionMetaDataAO entity = VersionMetaDataManagerImpl.this.versionMetaDataDao.getOne(versionId);
            if (entity == null) {
                return VersionMetaDataManagerImpl.this.createDefault(versionId);
            }
            return VersionMetaDataManagerImpl.this.versionMetaDataAOMapper.toModel(entity);
        }
    }
}

