/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.version;

import com.atlassian.greenhopper.manager.version.VersionMetaDataAO;
import com.atlassian.greenhopper.manager.version.VersionMetaDataAOMapper;
import com.atlassian.greenhopper.model.rapid.LegacyVersionMetaDataImpl;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionMetaDataDao
extends GenericActiveObjectsDao<Long, VersionMetaDataAO> {
    @Autowired
    private VersionMetaDataAOMapper versionMetaDataAOMapper;

    public VersionMetaDataAO getOne(Long versionId) {
        VersionMetaDataAO[] versionMetaDataAOs = (VersionMetaDataAO[])this.ao.find(VersionMetaDataAO.class, "VERSION_ID = ?", new Object[]{versionId});
        if (versionMetaDataAOs.length == 0) {
            return null;
        }
        if (versionMetaDataAOs.length > 1) {
            this.log.info("Expected only one record; got %d. Returning the first [id=%d]", versionMetaDataAOs.length, versionMetaDataAOs[0].getId());
        }
        return versionMetaDataAOs[0];
    }

    public VersionMetaDataAO updateOne(LegacyVersionMetaDataImpl versionMetaData) {
        VersionMetaDataAO versionMetaDataAO = this.getOne(versionMetaData.getVersionId());
        if (versionMetaDataAO != null) {
            this.versionMetaDataAOMapper.update(versionMetaData, versionMetaDataAO);
            versionMetaDataAO.save();
        } else {
            versionMetaDataAO = (VersionMetaDataAO)this.create(this.versionMetaDataAOMapper.toAO(versionMetaData));
        }
        return versionMetaDataAO;
    }
}

